/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openbp.common.icon.FlexibleSize;
import org.openbp.common.icon.MultiIcon;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraMenuItem;

public class JaspiraMenu
extends JMenu
implements FlexibleSize,
PropertyChangeListener,
HierarchyListener {
    private JaspiraAction action;
    private MultiIcon icon;
    private int iconSize;

    public JaspiraMenu(JaspiraAction action) {
        super(action);
        this.action = action;
        this.copyFromAction(null);
        action.addPropertyChangeListener(this);
        this.addActionListener(action);
        this.icon = action.getIcon();
        if (this.icon != null) {
            this.setIcon(this.icon.getIcon(16));
        }
    }

    private void copyFromAction(String propertyName) {
        if (propertyName == null || propertyName.equals("name")) {
            this.setActionCommand(this.action.getName());
        }
        if (propertyName == null || propertyName.equals("displayName")) {
            this.setText(this.action.getDisplayName());
        }
        if (propertyName == null || propertyName.equals("description")) {
            this.setToolTipText(this.action.getDescription());
        }
        if (propertyName == null || propertyName.equals("enabled")) {
            this.setEnabled(this.action.isEnabled());
        }
        if (propertyName == null && this.action.isMnemonic()) {
            this.setMnemonic(this.action.getMnemonicChar());
            this.setDisplayedMnemonicIndex(this.action.getMnemonicPos());
        }
    }

    public JaspiraAction getJaspiraAction() {
        return this.action;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (!this.isShowing()) {
            this.action.removePropertyChangeListener(this);
        } else {
            this.action.addPropertyChangeListener(this);
        }
    }

    public JMenuItem add(JaspiraAction a) {
        return a != null ? this.add(a.toMenuItem()) : null;
    }

    public JMenuItem add(JaspiraMenuItem mi) {
        if (mi == null) {
            return null;
        }
        mi.setIconSize(this.iconSize);
        return super.add(mi);
    }

    @Override
    public JMenuItem add(JMenuItem mi) {
        return mi != null ? super.add(mi) : null;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
        Component[] comps = this.getMenuComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof FlexibleSize)) continue;
            ((FlexibleSize)comps[i]).setIconSize(iconSize);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void addSeparator() {
        super.addSeparator();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.copyFromAction(evt.getPropertyName());
    }
}

