/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.border.EmptyBorder;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.keys.KeySequence;
import org.openbp.jaspira.gui.plugin.PluginPanel;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.swing.AdvancedAccelerator;
import org.openbp.swing.components.popupfield.JSelectionField;

public class JaspiraToolbarCombo
extends JSelectionField
implements ActionListener,
PropertyChangeListener,
HierarchyListener,
AdvancedAccelerator {
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_SELECTION_VALUE = "selectionvalue";
    public static final String PROPERTY_SELECTION_TEXT = "selectiontext";
    public static final String PROPERTY_SELECTEDITEM = "selectedItem";
    public static final String PROPERTY_TEXT = "text";
    private JaspiraAction action;

    public JaspiraToolbarCombo(JaspiraAction action) {
        this.action = action;
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.copyFromAction(null);
        action.addPropertyChangeListener(this);
        this.addActionListener(this);
    }

    private void copyFromAction(String propertyName) {
        Object value;
        if (propertyName == null || propertyName.equals("displayName")) {
            this.setLabelText(this.action.getDisplayName());
        }
        if (propertyName == null || propertyName.equals("description")) {
            this.setToolTipText(this.action.getDescription());
        }
        if (propertyName == null || propertyName.equals("enabled")) {
            this.setEnabled(this.action.isEnabled());
        }
        if (propertyName == null || propertyName.equals(PROPERTY_EDITABLE)) {
            this.setEditable(this.action.getActionPropertyBoolean(PROPERTY_EDITABLE, false));
        }
        if (propertyName == null) {
            String key;
            Object value2;
            this.clearItems();
            int i = 0;
            while ((value2 = this.action.getActionProperty(key = PROPERTY_SELECTION_VALUE + i)) != null) {
                key = PROPERTY_SELECTION_TEXT + i;
                String text = this.action.getActionPropertyString(key);
                this.addItem(text, value2);
                ++i;
            }
            this.adjustPreferredSize();
        }
        boolean set = false;
        if (!(propertyName != null && !propertyName.equals(PROPERTY_SELECTEDITEM) || (value = this.action.getActionProperty(PROPERTY_SELECTEDITEM)) == null && propertyName == null)) {
            this.setSelectedItem(value);
            set = true;
        }
        if (!(propertyName != null && !propertyName.equals(PROPERTY_TEXT) || (value = this.action.getActionPropertyString(PROPERTY_TEXT)) == null && propertyName == null)) {
            this.setText((String)value);
            set = true;
        }
        if (propertyName == null && !set) {
            this.setText(null);
        }
    }

    public String getAcceleratorString() {
        KeySequence[] ks = this.action.getKeySequences();
        if (ks != null && ks.length > 0) {
            return ks[0].toString();
        }
        return null;
    }

    public JaspiraAction getJaspiraAction() {
        return this.action;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (!this.isShowing()) {
            this.action.removePropertyChangeListener(this);
        } else {
            this.action.addPropertyChangeListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        for (Object c = this; c != null; c = ((Component)c).getParent()) {
            PluginPanel pluginPanel;
            VisiblePlugin plugin;
            if (!(c instanceof PluginPanel) || (plugin = (pluginPanel = (PluginPanel)c).getPlugin()) == null) continue;
            plugin.focusPlugin();
        }
        String text = this.getText();
        this.action.putValue(PROPERTY_TEXT, text);
        this.action.actionPerformed(event);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.copyFromAction(evt.getPropertyName());
    }
}

