/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.event;

import java.util.EventObject;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.Plugin;

public class JaspiraEvent
extends EventObject {
    public static final int TYPE_DIRECT = 0;
    public static final int TYPE_BOTTOM_UP = 1;
    public static final int TYPE_FLOOD = 2;
    public static final int TYPE_GLOBAL = 3;
    public static final int UNCONSUMABLE = 1;
    public static final int STACKABLE = 2;
    public static final int CONSUMED = 4;
    public static final int HANDELED = 8;
    private String eventName;
    private Object object;
    private int flags;
    private int type;
    private int level;
    private Plugin brand;
    private String eventGroup;
    private String targetClassName;
    private String targetPluginId;

    public JaspiraEvent(Plugin source, String eventName, Object object, int type, int level, int flags) {
        super(source != null ? source : ApplicationBase.getInstance());
        if (eventName == null || eventName.length() == 0) {
            throw new IllegalArgumentException("EventName must not be null");
        }
        this.eventName = eventName.toLowerCase();
        this.flags = flags;
        this.object = object;
        this.level = level;
        this.type = type;
        int index = eventName.lastIndexOf(46);
        this.eventGroup = index >= 0 ? eventName.substring(0, index) : eventName;
    }

    public JaspiraEvent(Plugin source, String eventName) {
        this(source, eventName, null, 2, 0, 0);
    }

    public JaspiraEvent(Plugin source, String eventName, Object object) {
        this(source, eventName, object, 2, 0, 0);
    }

    public JaspiraEvent(Plugin source, String eventName, int type, int level) {
        this(source, eventName, null, type, level, 0);
    }

    public JaspiraEvent(Plugin source, String eventName, Object object, int type, int level) {
        this(source, eventName, object, type, level, 0);
    }

    public EventObject getOriginalEvent() {
        return this.getObject() instanceof EventObject ? (EventObject)this.getObject() : null;
    }

    public Plugin getSourcePlugin() {
        return (Plugin)this.getSource();
    }

    public String getEventName() {
        return this.eventName;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isUnconsumable() {
        return (this.flags & 1) != 0;
    }

    public boolean isConsumed() {
        return (this.flags & 4) != 0;
    }

    public boolean isStackable() {
        return (this.flags & 2) != 0;
    }

    public void updateFlags(int flag) {
        this.flags |= flag;
    }

    public boolean updateFlags(JaspiraEventHandlerCode returnCode) {
        if (returnCode == EventModule.EVENT_CONSUMED && !this.isUnconsumable()) {
            this.flags |= 4;
            return true;
        }
        if (returnCode == EventModule.EVENT_HANDLED) {
            this.flags |= 8;
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setTargetClassName(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    public String getTargetPluginId() {
        return this.targetPluginId;
    }

    public void setTargetPluginId(String targetPluginId) {
        this.targetPluginId = targetPluginId;
    }

    @Override
    public String toString() {
        return "[JaspiraEvent] " + this.getEventName() + " from: " + this.source;
    }

    public Plugin getBrand() {
        return this.brand;
    }

    public void brand(Plugin brand) {
        this.brand = brand;
    }

    public String getEventGroup() {
        return this.eventGroup;
    }
}

