/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.clipboard;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.common.listener.ListenerSupport;

public final class ClipboardMgr
implements ClipboardOwner {
    public static final int DEFAULT_CAPACITY = 1;
    private LinkedList entries = new LinkedList();
    private int capacity = 1;
    private Clipboard systemClipboard;
    private static ClipboardMgr instance;
    private ListenerSupport listenerSupport;

    public static synchronized ClipboardMgr getInstance() {
        if (instance == null) {
            instance = new ClipboardMgr();
        }
        return instance;
    }

    private ClipboardMgr() {
    }

    public int getNumberOfEntries() {
        return this.entries.size();
    }

    public void addEntry(Transferable entry) {
        if (entry == null) {
            return;
        }
        this.entries.remove(entry);
        this.entries.addFirst(entry);
        while (this.entries.size() > this.capacity) {
            this.entries.removeLast();
        }
        if (this.systemClipboard != null) {
            try {
                this.systemClipboard.setContents(entry, this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.fireClipboardChanged();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        boolean removed = false;
        while (this.entries.size() > capacity) {
            this.entries.removeLast();
            removed = true;
        }
        if (removed) {
            this.fireClipboardChanged();
        }
    }

    public Transferable getCurrentEntry() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return (Transferable)this.entries.getFirst();
    }

    public Transferable getEntryAt(int index) {
        return (Transferable)this.entries.get(index);
    }

    public List getEntries() {
        return this.entries;
    }

    protected void fireClipboardChanged() {
        if (this.listenerSupport != null && this.listenerSupport.containsListeners(ChangeListener.class)) {
            ChangeEvent e = null;
            Iterator it = this.listenerSupport.getListenerIterator(ChangeListener.class);
            while (it.hasNext()) {
                if (e == null) {
                    e = new ChangeEvent(this);
                }
                ((ChangeListener)it.next()).stateChanged(e);
            }
        }
    }

    public synchronized void addClipboardListener(ChangeListener listener) {
        if (this.listenerSupport == null) {
            this.listenerSupport = new ListenerSupport();
        }
        this.listenerSupport.addWeakListener(ChangeListener.class, (EventListener)listener);
    }

    public synchronized void removeClipboardListener(ChangeListener listener) {
        if (this.listenerSupport != null) {
            this.listenerSupport.removeListener(ChangeListener.class, (EventListener)listener);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.addEntry(clipboard.getContents(null));
    }
}

