/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.clipboard;

import java.awt.datatransfer.Transferable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.clipboard.ClipboardMgr;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;

public class ClipboardPlugin
extends AbstractPlugin
implements ChangeListener {
    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.standard";
    }

    @Override
    protected void pluginInstalled() {
        super.pluginInstalled();
        ClipboardMgr.getInstance().addClipboardListener(this);
    }

    @Override
    protected void pluginUninstalled() {
        super.pluginUninstalled();
        ClipboardMgr.getInstance().removeClipboardListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireEvent("global.clipboard.updatestatus");
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "global.clipboard";
        }

        public JaspiraEventHandlerCode cut(JaspiraActionEvent je) {
            VisiblePlugin target = PluginFocusMgr.getInstance().getFocusedPlugin();
            if (target != null && target.canCut()) {
                ClipboardMgr.getInstance().addEntry(target.cut());
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode delete(JaspiraActionEvent je) {
            VisiblePlugin target = PluginFocusMgr.getInstance().getFocusedPlugin();
            if (target != null && target.canDelete()) {
                target.delete();
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode copy(JaspiraActionEvent je) {
            VisiblePlugin target = PluginFocusMgr.getInstance().getFocusedPlugin();
            if (target != null && target.canCopy()) {
                ClipboardMgr.getInstance().addEntry(target.copy());
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode paste(JaspiraActionEvent je) {
            VisiblePlugin target = PluginFocusMgr.getInstance().getFocusedPlugin();
            if (target != null) {
                Transferable transferable = ClipboardMgr.getInstance().getCurrentEntry();
                if (transferable != null && target.canPaste(transferable)) {
                    target.paste(transferable);
                }
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode updatestatus(JaspiraEvent je) {
            JaspiraAction pasteAction;
            JaspiraAction deleteAction;
            JaspiraAction cutAction;
            ActionMgr am;
            JaspiraAction copyAction;
            boolean canCopy = false;
            boolean canCut = false;
            boolean canDelete = false;
            boolean canPaste = false;
            VisiblePlugin target = PluginFocusMgr.getInstance().getFocusedPlugin();
            if (target != null) {
                canCopy = target.canCopy();
                canCut = target.canCut();
                canDelete = target.canDelete();
                Transferable transferable = ClipboardMgr.getInstance().getCurrentEntry();
                if (transferable != null) {
                    canPaste = target.canPaste(transferable);
                }
            }
            if ((copyAction = (am = ActionMgr.getInstance()).getAction("global.clipboard.copy")) != null) {
                copyAction.setEnabled(canCopy);
            }
            if ((cutAction = am.getAction("global.clipboard.cut")) != null) {
                cutAction.setEnabled(canCut);
            }
            if ((deleteAction = am.getAction("global.clipboard.delete")) != null) {
                deleteAction.setEnabled(canDelete);
            }
            if ((pasteAction = am.getAction("global.clipboard.paste")) != null) {
                pasteAction.setEnabled(canPaste);
            }
            return EVENT_IGNORED;
        }
    }
}

