/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openbp.common.ExceptionUtil;

public class MultiTransferable
implements Transferable {
    private Map flavorMap = new LinkedHashMap();
    private DataFlavor[] acceptedFlavors;

    public MultiTransferable() {
    }

    public MultiTransferable(Collection transferables) {
        this();
        Iterator it = transferables.iterator();
        while (it.hasNext()) {
            this.addTransferable((Transferable)it.next());
        }
    }

    public MultiTransferable(Transferable[] transferables) {
        this();
        for (int i = 0; i < transferables.length; ++i) {
            this.addTransferable(transferables[i]);
        }
    }

    public void addTransferable(Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (this.flavorMap.containsKey(flavors[i])) continue;
            this.flavorMap.put(flavors[i], transferable);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.acceptedFlavors == null) {
            this.acceptedFlavors = new DataFlavor[this.flavorMap.size()];
            this.flavorMap.keySet().toArray(this.acceptedFlavors);
        }
        return this.acceptedFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavorMap.containsKey(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Transferable sub = (Transferable)this.flavorMap.get(flavor);
        if (sub == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return sub.getTransferData(flavor);
    }

    public Object getSafeTransferData(DataFlavor flavor) {
        try {
            return this.getTransferData(flavor);
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        return null;
    }
}

