/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.Component;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.SwingUtilities;

public class RectangleSegment
extends RectangularShape {
    public static final String CENTER = "center";
    public static final String NORTH = "north";
    public static final String SOUTH = "south";
    public static final String EAST = "east";
    public static final String WEST = "west";
    private Polygon polygon;

    public RectangleSegment(Point p, int width, String constraint) {
        this(p.x, p.y, width, constraint);
    }

    public RectangleSegment(Component comp, int width, String constraint) {
        this(SwingUtilities.getLocalBounds(comp), width, constraint);
    }

    public RectangleSegment(Rectangle rectangle, int width, String constraint) {
        this(rectangle.width, rectangle.height, width, constraint);
    }

    public RectangleSegment(int x, int y, int width, String constraint) {
        this.polygon = NORTH.equals(constraint) ? new Polygon(new int[]{0, x, x - width, width}, new int[]{0, 0, width, width}, 4) : (SOUTH.equals(constraint) ? new Polygon(new int[]{0, x, x - width, width}, new int[]{y, y, y - width, y - width}, 4) : (WEST.equals(constraint) ? new Polygon(new int[]{0, width, width, 0}, new int[]{0, width, y - width, y}, 4) : (EAST.equals(constraint) ? new Polygon(new int[]{x, x - width, x - width, x}, new int[]{y, y - width, width, 0}, 4) : new Polygon(new int[]{width, x - width, x - width, width}, new int[]{width, width, y - width, y - width}, 4))));
    }

    @Override
    public double getX() {
        return this.polygon.getBounds().getX();
    }

    @Override
    public double getY() {
        return this.polygon.getBounds().getY();
    }

    @Override
    public double getWidth() {
        return this.polygon.getBounds().getWidth();
    }

    @Override
    public double getHeight() {
        return this.polygon.getBounds().getHeight();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        this.polygon.translate((int)(x - this.getX()), (int)(y - this.getY()));
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.polygon.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.polygon.contains(x, y);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.polygon.intersects(x, y, w, h);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.polygon.contains(x, y, w, h);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.polygon.getPathIterator(at);
    }
}

