/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.interaction;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import javax.swing.JScrollPane;
import org.openbp.jaspira.gui.interaction.BasicDropRegion;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.swing.SwingUtil;

public class ViewDropRegion
extends BasicDropRegion {
    protected Rectangle clipRect;

    public ViewDropRegion(Object id, InteractionClient parent, RectangularShape shape, Component origin) {
        super(id, parent, shape, origin);
        JScrollPane scrollPane = SwingUtil.getScrollPaneAncestor((Component)origin);
        if (scrollPane != null) {
            this.clipRect = SwingUtil.convertBoundsToGlassCoords((Component)scrollPane.getViewport());
        }
    }

    @Override
    public boolean reactsOn(int x, int y) {
        if (this.clipRect != null && !this.clipRect.contains(x, y)) {
            return false;
        }
        return super.reactsOn(x, y);
    }

    @Override
    public void draw(Graphics2D g) {
        Shape oldClip = g.getClip();
        if (this.clipRect != null) {
            g.setClip(this.clipRect);
        }
        super.draw(g);
        g.setClip(oldClip);
    }
}

