/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.action.keys.KeyMgr;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.VetoableEvent;
import org.openbp.jaspira.gui.interaction.BasicDragReactor;
import org.openbp.jaspira.gui.interaction.BasicDropRegion;
import org.openbp.jaspira.gui.interaction.DragDropPane;
import org.openbp.jaspira.gui.interaction.DropClientUtil;
import org.openbp.jaspira.gui.interaction.DropPaneContainer;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.plugin.ApplicationBase;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.JaspiraPageTransferable;
import org.openbp.jaspira.gui.plugin.PluginContainer;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.PluginFrame;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugin.PluginState;
import org.openbp.jaspira.plugins.statusbar.StatusBarPlugin;
import org.openbp.jaspira.util.StandardFlavors;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class JaspiraPageContainer
extends JFrame
implements PluginContainer,
InteractionClient,
DropPaneContainer,
Plugin,
WindowFocusListener {
    private static final Font BUTTON_FONT = new Font("arial", 0, 10);
    private static final Color HOTKEY_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.4f);
    public static final Dimension MIN_FRAME_SIZE = new Dimension(800, 600);
    private static final String OPENINFRAME_REGION = "openinframe";
    private static ResourceCollection resourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("jaspira", JaspiraPageContainer.class);
    private AbstractPlugin delegatePlugin;
    private JPanel pagePanel;
    private JPanel pageButtonPanel;
    private CardLayout cardLayout;
    private JaspiraToolbar toolbar;
    private JaspiraToolbar pageButtonBar;
    private JLabel openInDialogLabel;
    private Map pageButtonsByPage;
    private ButtonGroup buttonGroup;
    private JaspiraPage activePage;
    private InputMap inputmap;
    private ActionMap actionmap;
    private int buttonSize;
    private Dimension buttonDim;
    private Font hotkeyFont;
    private static boolean displayPageButtonTitles;

    public JaspiraPageContainer(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.setJMenuBar(new JMenuBar());
        this.pageButtonsByPage = new HashMap();
        this.buttonGroup = new ButtonGroup();
        this.delegatePlugin = new AbstractPlugin(){

            @Override
            public ResourceCollection getPluginResourceCollection() {
                return resourceCollection;
            }

            @Override
            public String getResourceCollectionContainerName() {
                return null;
            }
        };
        this.delegatePlugin.setParentPlugin(ApplicationBase.getInstance());
        this.delegatePlugin.initializePlugin();
        this.delegatePlugin.installPlugin();
        if (displayPageButtonTitles) {
            this.buttonSize = 24;
            this.buttonDim = new Dimension(52, 40);
            this.hotkeyFont = new Font("arial", 1, 36);
        } else {
            this.buttonSize = 16;
            this.buttonDim = new Dimension(20, 20);
            this.hotkeyFont = new Font("arial", 1, 20);
        }
        this.pageButtonBar = new JaspiraToolbar(this.buttonSize, 1);
        this.pageButtonBar.setFloatable(false);
        this.inputmap = this.pageButtonBar.getInputMap(2);
        this.actionmap = this.pageButtonBar.getActionMap();
        this.inputmap.put(KeyStroke.getKeyStroke("alt pressed ALT"), "mark_on");
        this.inputmap.put(KeyStroke.getKeyStroke("released ALT"), "mark_off");
        this.inputmap.put(KeyStroke.getKeyStroke("ctrl released ALT"), "mark_off");
        this.actionmap.put("mark_on", new DisplayHotkeyAction(true));
        this.actionmap.put("mark_off", new DisplayHotkeyAction(false));
        this.toolbar = new JaspiraToolbar();
        this.toolbar.setFloatable(false);
        this.openInDialogLabel = new JLabel(((MultiIcon)this.getPluginResourceCollection().getRequiredObject("frame.plugininframe.icon")).getIcon(this.buttonSize));
        this.openInDialogLabel.setToolTipText(this.getPluginResourceCollection().getRequiredString("frame.plugininframe.description"));
        this.openInDialogLabel.setBackground(Color.WHITE);
        this.openInDialogLabel.setBorder((Border)SimpleBorder.getStandardBorder());
        this.openInDialogLabel.setMaximumSize(this.buttonDim);
        this.openInDialogLabel.setMinimumSize(this.buttonDim);
        this.openInDialogLabel.setPreferredSize(this.buttonDim);
        this.pageButtonPanel = new JPanel(new BorderLayout());
        this.pageButtonPanel.setBorder((Border)SimpleBorder.getStandardBorder());
        this.pageButtonPanel.add((Component)this.pageButtonBar, "North");
        this.pageButtonPanel.add(new JSeparator());
        this.pageButtonPanel.add((Component)this.openInDialogLabel, "South");
        StatusBarPlugin statusBar = (StatusBarPlugin)PluginMgr.getInstance().createInstance(StatusBarPlugin.class, (Plugin)this);
        this.cardLayout = new CardLayout();
        this.pagePanel = new JPanel(this.cardLayout);
        JPanel contentPanel = (JPanel)this.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.toolbar, "North");
        contentPanel.add(this.pagePanel);
        contentPanel.add((Component)this.pageButtonPanel, "West");
        contentPanel.add((Component)statusBar.getPluginComponent(), "South");
        this.setDefaultCloseOperation(0);
        this.addWindowFocusListener(this);
        KeyMgr.getInstance().install(contentPanel);
    }

    @Override
    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"pages");
    }

    public final void buildMenu() {
        String pageName = this.activePage != null ? this.activePage.getName() : null;
        JMenuBar mb = new JMenuBar();
        JaspiraAction root = ActionMgr.getInstance().getAction("menuroot");
        if (root.getMenuchildren() != null) {
            for (JaspiraAction action : root.getMenuchildren()) {
                JMenuItem menuItem;
                if (!action.matchesPageName(pageName) || (menuItem = action.toMenuItem(pageName)) == null) continue;
                mb.add(menuItem);
            }
        }
        this.setJMenuBar(mb);
        this.toolbar.removeAll();
        root = ActionMgr.getInstance().getAction("toolbarroot");
        if (root.getToolbarchildren() != null) {
            for (JaspiraAction action : root.getToolbarchildren()) {
                JComponent toolbarComponent;
                if (!action.matchesPageName(pageName) || (toolbarComponent = action.toToolBarComponent(pageName)) == null) continue;
                this.toolbar.add(toolbarComponent);
                this.toolbar.addSeparator();
            }
        }
        this.toolbar.repaint();
    }

    void showPageHotkeys(boolean show) {
        Iterator it = this.pageButtonsByPage.values().iterator();
        while (it.hasNext()) {
            ((PageButton)it.next()).showHotkey(show);
        }
    }

    public void addPage(JaspiraPage page) {
        int numberOfPages;
        int pageNr = this.pageButtonsByPage.size() + 1;
        String id = page.getUniqueId();
        this.pagePanel.add((Component)page.getPluginComponent(), id);
        PageButton pageButton = new PageButton(page, pageNr, displayPageButtonTitles);
        KeyStroke show = KeyStroke.getKeyStroke("alt " + pageNr);
        KeyStroke open = KeyStroke.getKeyStroke("alt shift " + pageNr);
        this.inputmap.put(show, "show" + id);
        this.inputmap.put(open, "open" + id);
        this.actionmap.put("show" + id, new ShowAction(page));
        this.actionmap.put("open" + id, new OpenAction(page));
        this.pageButtonBar.add(pageButton);
        this.buttonGroup.add(pageButton);
        this.pageButtonsByPage.put(page, pageButton);
        if (this.activePage == null) {
            this.setPageActive(page);
        }
        this.pageButtonPanel.setVisible((numberOfPages = this.pageButtonsByPage.size()) > 1);
        DragDropPane.installDragDropPane(this);
        page.setParentPlugin(this);
        this.buildMenu();
        this.fireEvent("global.page.added", page);
        page.fireEvent(new JaspiraEvent(page, "global.enviroment.rebuild", null, 2, 2, 2));
    }

    public void removePage(JaspiraPage page) {
        this.cardLayout.removeLayoutComponent(page.getPluginComponent());
        PageButton pageButton = (PageButton)this.pageButtonsByPage.remove(page);
        this.pageButtonBar.remove(pageButton);
        this.buttonGroup.remove(pageButton);
        if (this.pageButtonsByPage.size() == 0 && ApplicationBase.getInstance().getFrameCount() != 1) {
            this.dispose();
        } else {
            JaspiraPage newActivePage = null;
            Component[] comp = this.pageButtonBar.getComponents();
            for (int i = 0; i < comp.length; ++i) {
                pageButton = (PageButton)comp[i];
                if (newActivePage == null) {
                    newActivePage = pageButton.getPage();
                }
                int pageNr = i + 1;
                pageButton.setPageNr(pageNr);
                JaspiraPage p = pageButton.getPage();
                String id = p.getUniqueId();
                KeyStroke show = KeyStroke.getKeyStroke("alt " + pageNr);
                KeyStroke open = KeyStroke.getKeyStroke("alt shift " + pageNr);
                this.inputmap.put(show, "show" + id);
                this.inputmap.put(open, "open" + id);
                this.actionmap.put("show" + id, new ShowAction(p));
                this.actionmap.put("open" + id, new OpenAction(p));
            }
            this.pageButtonBar.revalidate();
            if (page == this.activePage && newActivePage != null) {
                this.setPageActive(newActivePage);
            }
        }
        this.fireEvent("global.page.removed", page);
    }

    public void openInNewFrame(JaspiraPage page) {
        if (this.pageButtonsByPage.size() == 1) {
            return;
        }
        this.removePage(page);
        GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice current = this.getGraphicsConfiguration().getDevice();
        if (devs.length == 1) {
            ApplicationBase.getInstance().addFrame(page, MIN_FRAME_SIZE, 6);
        } else {
            GraphicsDevice gd = devs[0];
            for (int i = 0; i < devs.length && gd == current; ++i) {
                gd = devs[i];
            }
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            ApplicationBase.getInstance().addFrame(page, MIN_FRAME_SIZE, ApplicationBase.getInstance().hasFrameForGraphicsConfiguration(gc) ? 0 : 6, gc);
        }
    }

    public List getPages() {
        return new ArrayList(this.pageButtonsByPage.keySet());
    }

    public JaspiraPage getActivePage() {
        return this.activePage;
    }

    public void setPageActive(JaspiraPage page) {
        if (!this.containsPage(page)) {
            return;
        }
        VetoableEvent ask = new VetoableEvent((Plugin)this, "global.page.askchange", this.activePage, page);
        this.fireEvent(ask);
        if (ask.isVetoed()) {
            return;
        }
        this.cardLayout.show(this.pagePanel, page.getUniqueId());
        this.activePage = page;
        ((PageButton)this.pageButtonsByPage.get(page)).setSelected(true);
        this.buildMenu();
        this.fireEvent("global.page.changed", page);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JaspiraPageContainer.this.activePage.restoreFocus();
            }
        });
    }

    public boolean containsPage(JaspiraPage page) {
        return this.pageButtonsByPage.containsKey(page);
    }

    public JaspiraToolbar getToolbar() {
        return this.toolbar;
    }

    @Override
    public JaspiraPage getPage() {
        return null;
    }

    @Override
    public void addPlugin(VisiblePlugin p) {
        if (this.activePage != null) {
            this.activePage.addPlugin(p);
        }
    }

    @Override
    public void removePlugin(VisiblePlugin p) {
        Iterator it = this.getPages().iterator();
        while (it.hasNext()) {
            ((JaspiraPage)it.next()).removePlugin(p);
        }
    }

    @Override
    public VisiblePlugin getActivePlugin() {
        return this.activePage != null ? this.activePage.getActivePlugin() : null;
    }

    @Override
    public PluginContainer getParentContainer() {
        return null;
    }

    @Override
    public List getPlugins() {
        ArrayList list = new ArrayList();
        Iterator it = this.getPages().iterator();
        while (it.hasNext()) {
            list.addAll(((JaspiraPage)it.next()).getPlugins());
        }
        return list;
    }

    @Override
    public List getVisiblePlugins() {
        return this.activePage != null ? this.activePage.getVisiblePlugins() : null;
    }

    @Override
    public void sliceContainer(PluginContainer toInsert, PluginContainer currentContainer, String constraint) {
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
        if (regionId instanceof PageButton) {
            PageButton pageButton = (PageButton)regionId;
            this.setPageActive(pageButton.getPage());
            this.getDragDropPane().regionsInvalidated();
        }
    }

    @Override
    public void dragStarted(Transferable transferable) {
        DropClientUtil.dragStarted(this, transferable);
    }

    @Override
    public void dragEnded(Transferable transferable) {
        DropClientUtil.dragEnded(this, transferable);
    }

    @Override
    public final List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return DropClientUtil.getAllDropRegions(this, flavors, data, mouseEvent);
    }

    @Override
    public final List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        ArrayList<BasicDropRegion> result = new ArrayList<BasicDropRegion>();
        List userRegions = this.getUserRegions(flavors);
        if (userRegions != null) {
            result.addAll(userRegions);
        }
        if (flavors.contains(StandardFlavors.PLUGIN) || flavors.contains(StandardFlavors.PLUGIN_STATE)) {
            BasicDropRegion region = new BasicDropRegion(OPENINFRAME_REGION, this, this.openInDialogLabel);
            region.setFrameColor(Color.BLUE);
            result.add(region);
        } else {
            for (PageButton next : this.pageButtonsByPage.values()) {
                BasicDragReactor region = new BasicDragReactor((Object)next, (InteractionClient)this, next, 1000L);
                result.add(region);
            }
        }
        return result;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return DropClientUtil.getAllImportersAt(this, p);
    }

    protected List getUserRegions(List flavors) {
        return null;
    }

    @Override
    public List getSubClients() {
        if (this.activePage != null) {
            return Collections.singletonList(this.activePage.getPluginDivider());
        }
        return null;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        if (regionId.equals(OPENINFRAME_REGION) && this.activePage != null) {
            try {
                VisiblePlugin plugin = null;
                if (data.isDataFlavorSupported(StandardFlavors.PLUGIN)) {
                    plugin = (VisiblePlugin)data.getTransferData(StandardFlavors.PLUGIN);
                    if (plugin.getPluginHolder() != null) {
                        plugin.getPluginHolder().unlinkHolder();
                    }
                } else if (data.isDataFlavorSupported(StandardFlavors.PLUGIN_STATE)) {
                    PluginState state = (PluginState)data.getTransferData(StandardFlavors.PLUGIN_STATE);
                    plugin = PluginMgr.getInstance().createVisibleInstance(state, null);
                }
                if (plugin != null) {
                    PluginFrame frame = new PluginFrame(plugin, this.activePage.getUniqueId());
                    Dimension size = plugin.getPluginComponent().getSize();
                    frame.setSize(size);
                    SwingUtil.show((JFrame)frame);
                    frame.toFront();
                    PluginFocusMgr.getInstance().resetFocusCache();
                    plugin.focusPlugin();
                    return true;
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void addDropClient(InteractionClient client) {
        this.getDragDropPane().addDropClient(client);
    }

    @Override
    public void removeDropClient(InteractionClient client) {
        this.getDragDropPane().removeDropClient(client);
    }

    @Override
    public DragDropPane getDragDropPane() {
        Component glassPane = this.getGlassPane();
        if (!(glassPane instanceof DragDropPane)) {
            return DragDropPane.installDragDropPane(this);
        }
        return (DragDropPane)glassPane;
    }

    @Override
    public void setDragDropPane(DragDropPane pane) {
        this.setGlassPane(pane);
        pane.addDropClient(this);
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public ResourceCollection getPluginResourceCollection() {
        return resourceCollection;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public Plugin getParentPlugin() {
        return ApplicationBase.getInstance();
    }

    @Override
    public void initializePlugin() {
        this.delegatePlugin.initializePlugin();
    }

    @Override
    public MultiIcon getIcon() {
        return this.delegatePlugin.getIcon();
    }

    @Override
    public String getSubTitle() {
        return this.delegatePlugin.getSubTitle();
    }

    @Override
    public Object getPeerGroup(String key) {
        return this.delegatePlugin.getPeerGroup(key);
    }

    @Override
    public boolean canClose() {
        return this.delegatePlugin.canClose();
    }

    @Override
    public boolean fireEvent(JaspiraEvent je) {
        return this.delegatePlugin.fireEvent(je);
    }

    @Override
    public boolean fireEvent(String eventname) {
        return this.delegatePlugin.fireEvent(eventname);
    }

    @Override
    public boolean fireEvent(String eventname, Object data) {
        return this.delegatePlugin.fireEvent(eventname, data);
    }

    @Override
    public List getChildPlugins() {
        return this.delegatePlugin.getChildPlugins();
    }

    @Override
    public List getDescendantPlugins(List plugins) {
        return this.delegatePlugin.getDescendantPlugins(plugins);
    }

    @Override
    public boolean handleEvent(JaspiraEvent je) {
        return this.delegatePlugin.handleEvent(je);
    }

    @Override
    public boolean inheritEvent(JaspiraEvent je) {
        return this.delegatePlugin.inheritEvent(je);
    }

    @Override
    public boolean receiveEvent(JaspiraEvent je) {
        return this.delegatePlugin.receiveEvent(je);
    }

    @Override
    public void setParentPlugin(Plugin plugin) {
        this.delegatePlugin.setParentPlugin(plugin);
    }

    @Override
    public void addPlugin(Plugin child) {
        this.delegatePlugin.addPlugin(child);
    }

    @Override
    public void removePlugin(Plugin child) {
        this.delegatePlugin.removePlugin(child);
    }

    @Override
    public void stackEvent(JaspiraEvent je) {
        this.delegatePlugin.stackEvent(je);
    }

    @Override
    public boolean containsStackedEvent(String eventName) {
        return this.delegatePlugin.containsStackedEvent(eventName);
    }

    @Override
    public boolean requestClose() {
        return this.delegatePlugin.requestClose();
    }

    @Override
    public void addToPeerGroup(String key, Object group) {
        this.delegatePlugin.addToPeerGroup(key, group);
    }

    @Override
    public String getDescription() {
        return this.delegatePlugin.getDescription();
    }

    @Override
    public Set getPeerGroups() {
        return this.delegatePlugin.getPeerGroups();
    }

    @Override
    public Set getPeerGroupNames() {
        return this.delegatePlugin.getPeerGroupNames();
    }

    @Override
    public String getUniqueId() {
        return this.delegatePlugin.getUniqueId();
    }

    @Override
    public String getVendor() {
        return this.delegatePlugin.getVendor();
    }

    @Override
    public String getVersion() {
        return this.delegatePlugin.getVersion();
    }

    @Override
    public String getCondition() {
        return this.delegatePlugin.getCondition();
    }

    @Override
    public void installPlugin() {
        this.delegatePlugin.installPlugin();
    }

    @Override
    public void installFirstPlugin() {
        this.delegatePlugin.installFirstPlugin();
    }

    @Override
    public boolean matchesPeerGroup(String key, Object group, boolean strict) {
        return this.delegatePlugin.matchesPeerGroup(key, group, strict);
    }

    @Override
    public boolean matchesPeerGroups(Plugin plugin, boolean strict) {
        return this.delegatePlugin.matchesPeerGroups(plugin, strict);
    }

    @Override
    public void removeFromPeerGroup(String key) {
        this.delegatePlugin.removeFromPeerGroup(key);
    }

    @Override
    public PluginState getPluginState() {
        return this.delegatePlugin.getPluginState();
    }

    @Override
    public void setPluginState(PluginState state) {
        this.delegatePlugin.setPluginState(state);
    }

    @Override
    public void uninstallPlugin() {
        this.delegatePlugin.uninstallPlugin();
    }

    @Override
    public void uninstallLastPlugin() {
        this.delegatePlugin.uninstallLastPlugin();
    }

    @Override
    public JaspiraAction getAction(String name) {
        return this.delegatePlugin.getAction(name);
    }

    @Override
    public List getEventActionNames() {
        return this.delegatePlugin.getEventActionNames();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.showPageHotkeys(false);
    }

    private class PageButton
    extends JToggleButton
    implements ActionListener {
        private JaspiraPage page;
        private String hotKeyString;
        private boolean hotkeyShown;

        public PageButton(JaspiraPage page, int nr, boolean displayTitle) {
            JPanel panel;
            this.page = page;
            this.setPageNr(nr);
            this.setActionCommand(page.getUniqueId());
            MultiIcon icon = page.getIcon();
            JLabel iconLabel = new JLabel(icon.getIcon(JaspiraPageContainer.this.buttonSize));
            iconLabel.setVerticalAlignment(0);
            iconLabel.setHorizontalAlignment(0);
            iconLabel.setForeground(Color.BLUE);
            iconLabel.setOpaque(false);
            if (displayTitle) {
                panel = new JPanel(new BorderLayout());
                panel.setOpaque(false);
                panel.add(iconLabel);
                JLabel titleLabel = new JLabel(page.getTitle());
                titleLabel.setFont(BUTTON_FONT);
                titleLabel.setOpaque(false);
                titleLabel.setHorizontalAlignment(0);
                panel.add((Component)titleLabel, "South");
                this.add(panel);
            } else {
                panel = new JPanel(new BorderLayout());
                panel.setOpaque(false);
                panel.add(iconLabel);
                this.add(panel);
            }
            this.setMinimumSize(JaspiraPageContainer.this.buttonDim);
            this.setMaximumSize(JaspiraPageContainer.this.buttonDim);
            this.setPreferredSize(JaspiraPageContainer.this.buttonDim);
            String s = page.getDescription();
            if (s == null) {
                s = page.getTitle();
            }
            this.setToolTipText(s);
            this.addActionListener(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    if (me.isPopupTrigger()) {
                        InteractionEvent iae = new InteractionEvent((Plugin)JaspiraPageContainer.this, "popup", new JaspiraPageTransferable(PageButton.this.page));
                        JaspiraPageContainer.this.fireEvent(iae);
                        iae.createPopupMenu().show(me.getComponent(), me.getX(), me.getY());
                    }
                }
            });
        }

        public JaspiraPage getPage() {
            return this.page;
        }

        public void setPageNr(int nr) {
            this.hotKeyString = Integer.toString(nr, 10);
        }

        public void showHotkey(boolean show) {
            if (show != this.hotkeyShown) {
                this.hotkeyShown = show;
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.hotkeyShown) {
                g.setColor(HOTKEY_COLOR);
                g.setFont(JaspiraPageContainer.this.hotkeyFont);
                FontMetrics fm = g.getFontMetrics();
                int textWidth = SwingUtilities.computeStringWidth(fm, this.hotKeyString);
                int w = this.getWidth();
                int h = this.getHeight();
                int x = (w - textWidth) / 2;
                int y = h / 2 + fm.getAscent() / 2 - fm.getLeading();
                g.drawString(this.hotKeyString, x, y);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JaspiraPageContainer.this.setPageActive(this.page);
        }
    }

    private class DisplayHotkeyAction
    extends AbstractAction {
        private boolean show;

        public DisplayHotkeyAction(boolean show) {
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JaspiraPageContainer.this.showPageHotkeys(this.show);
        }
    }

    private class OpenAction
    extends AbstractAction {
        private JaspiraPage page;

        public OpenAction(JaspiraPage page) {
            this.page = page;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JaspiraPageContainer.this.showPageHotkeys(false);
            JaspiraPageContainer.this.openInNewFrame(this.page);
        }
    }

    private class ShowAction
    extends AbstractAction {
        private JaspiraPage page;

        public ShowAction(JaspiraPage page) {
            this.page = page;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JaspiraPageContainer.this.showPageHotkeys(false);
            JaspiraPageContainer.this.setPageActive(this.page);
        }
    }
}

