/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.plugin;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openbp.common.icon.MultiIcon;
import org.openbp.jaspira.action.JaspiraToolbar;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.gui.plugin.PluginHolder;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;

public class PluginFrame
extends JFrame
implements PluginHolder {
    private VisiblePlugin plugin;
    private String returnPageId;
    private JaspiraToolbar mainToolbar;

    public PluginFrame(VisiblePlugin plugin, String returnPageId, GraphicsConfiguration gc) {
        super(plugin.getTitle(), gc);
        this.init(plugin, returnPageId);
    }

    public PluginFrame(VisiblePlugin plugin, String returnPageId) {
        this(plugin, returnPageId, null);
    }

    protected void init(VisiblePlugin plugin, String returnPageId) {
        this.plugin = plugin;
        this.returnPageId = returnPageId;
        plugin.setPluginHolder(this);
        this.initIcon();
        JComponent comp = plugin.getPluginComponent();
        this.getContentPane().add(comp);
        this.buildToolBar();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PluginFrame.this.close();
            }
        });
    }

    private void initIcon() {
        MultiIcon icon = this.plugin.getIcon();
        BufferedImage buf = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = buf.getGraphics();
        icon.paintIcon(this, g, 0, 0);
        this.setIconImage(buf);
    }

    protected void buildToolBar() {
        if (this.mainToolbar != null) {
            this.getContentPane().remove(this.mainToolbar);
        }
        this.mainToolbar = new JaspiraToolbar();
        this.mainToolbar.setFloatable(false);
        JaspiraToolbar toolbar = this.plugin.createToolbar();
        if (toolbar != null) {
            this.mainToolbar.add((Component)toolbar, "West");
        }
        this.getContentPane().add((Component)this.mainToolbar, "North");
    }

    public void close() {
        Plugin page;
        this.dispose();
        if (this.returnPageId != null && (page = PluginMgr.getInstance().getPlugin(this.returnPageId)) != null) {
            this.plugin.setPluginHolder(this.plugin.getPluginPanel());
            this.plugin.getPluginPanel().initTitleBar();
            ((JaspiraPage)page).addPlugin(this.plugin);
            return;
        }
        PluginMgr.getInstance().removeInstance(this.plugin);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(visible);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void showHolder(boolean changePage) {
        this.toFront();
    }

    @Override
    public void updateHolder(boolean fullRebuild) {
        if (fullRebuild || this.mainToolbar == null) {
            this.buildToolBar();
        }
        this.setTitle(this.plugin.getTitle());
    }

    @Override
    public void unlinkHolder() {
        this.dispose();
    }
}

