/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.openbp.common.ExceptionUtil;
import org.openbp.jaspira.gui.wizard.JaspiraWizardPage;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.SwingWorker;
import org.openbp.swing.components.JConsole;
import org.openbp.swing.components.JMsgBox;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.plaf.sky.SimpleBorder;

public abstract class JaspiraWizardResultPage
extends JaspiraWizardPage
implements Runnable {
    protected JPanel progressPanel;
    protected JPanel textPanel;
    private JProgressBar progressBar;
    private JTextArea textArea;
    private JConsole console;
    private int threadAction = 0;
    private int progressCount;
    private String progressText;
    private int textHeight;
    private boolean oldMoveForward;
    private boolean oldMoveBackward;
    private boolean oldFinish;
    private boolean oldCancel;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_UPDATE_UI = 1;
    private static final int ACTION_END = 2;
    private static final int ACTION_ERROR = 3;

    public JaspiraWizardResultPage(Wizard wizard) {
        super(wizard);
        JPanel cp = this.getContentPanel();
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(10000, 30));
        this.progressPanel = new JPanel(new BorderLayout());
        this.progressPanel.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.progressPanel.add((Component)this.progressBar, "North");
        cp.add((Component)this.progressPanel, "North");
        this.textArea = new JTextArea();
        this.textArea.setFont(this.getFont());
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setOpaque(false);
        this.textPanel = new JPanel(new BorderLayout());
        this.textPanel.setBorder(new EmptyBorder(5, 2, 5, 5));
        this.textPanel.add((Component)this.textArea, "Center");
        cp.add((Component)this.textPanel, "South");
        this.console = new JConsole();
        this.console.setBorder((Border)new CompoundBorder(new EmptyBorder(5, 2, 5, 5), (Border)SimpleBorder.getStandardBorder()));
        cp.add((Component)this.console, "Center");
        this.canFinish = false;
    }

    public void start() {
        this.oldMoveForward = this.canMoveForward;
        this.oldMoveBackward = this.canMoveBackward;
        this.oldFinish = this.canFinish;
        this.oldCancel = this.canCancel;
        this.canMoveForward = false;
        this.canMoveBackward = false;
        this.canFinish = false;
        this.canCancel = false;
        this.updateNavigator();
        this.console.flush();
        try {
            this.preProcess();
            SwingUtil.waitCursorOn((Component)((JComponent)this.getWizard()));
            Worker worker = new Worker();
            worker.start();
        }
        catch (Exception e) {
            this.processException(e);
            try {
                this.postProcess(false);
            }
            catch (Exception e2) {
                this.processException(e2);
            }
        }
    }

    public void handleWizardEvent(WizardEvent event) {
        if (event.eventType == 0) {
            this.start();
        }
    }

    protected abstract void preProcess() throws Exception;

    protected abstract void process() throws Exception;

    protected abstract void postProcess(boolean var1) throws Exception;

    protected void processException(Throwable t) {
        String msg = ExceptionUtil.getNestedMessage((Throwable)t);
        if (msg != null) {
            System.err.println(msg);
            JMsgBox.show(null, (String)msg, (int)0x40040001);
        }
    }

    @Override
    public void run() {
        try {
            if (this.threadAction == 1) {
                this.internalUpdatePage();
            } else if (this.threadAction == 2) {
                this.threadAction = 0;
                SwingUtil.waitCursorOff((Component)((JComponent)this.getWizard()));
                this.canMoveForward = this.oldMoveForward;
                this.canMoveBackward = this.oldMoveBackward;
                this.canFinish = this.oldFinish;
                this.canCancel = this.oldCancel;
                this.updateNavigator();
                this.postProcess(true);
            } else if (this.threadAction == 3) {
                this.threadAction = 0;
                SwingUtil.waitCursorOff((Component)((JComponent)this.getWizard()));
                this.canMoveForward = this.oldMoveForward;
                this.canMoveBackward = this.oldMoveBackward;
                this.canFinish = this.oldFinish;
                this.canCancel = this.oldCancel;
                this.updateNavigator();
                this.postProcess(false);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
    }

    public int getProgressCount() {
        return this.progressCount;
    }

    public void setProgressCount(int progressCount) {
        this.progressCount = progressCount;
    }

    public String getProgressText() {
        return this.progressText;
    }

    public void setProgressText(String progressText) {
        this.progressText = progressText;
    }

    protected void updatePage(boolean wait) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalUpdatePage();
        } else {
            this.threadAction = 1;
            if (wait) {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception e) {
                    ExceptionUtil.printTrace((Throwable)e);
                }
            } else {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    protected void internalUpdatePage() {
        if (this.progressCount >= 0) {
            this.progressBar.setValue(this.progressCount);
        }
        if (this.progressText != null) {
            this.textArea.setText(this.progressText);
            this.textArea.setVisible(true);
            this.getContentPanel().validate();
        } else {
            if (this.textHeight == 0) {
                this.textArea.setVisible(false);
                this.getContentPanel().validate();
            }
            this.textArea.setText(this.progressText);
        }
        this.updateNavigator();
    }

    public JPanel getProgressPanel() {
        return this.progressPanel;
    }

    public JPanel getTextPanel() {
        return this.textPanel;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public JConsole getConsole() {
        return this.console;
    }

    public void setTextHeight(int textHeight) {
        this.textHeight = textHeight;
        Dimension dim = null;
        if (textHeight != 0) {
            dim = new Dimension(10000, textHeight);
        }
        this.textArea.setMinimumSize(dim);
        this.textArea.setMaximumSize(dim);
        this.textArea.setPreferredSize(dim);
    }

    private class Worker
    extends SwingWorker {
        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            try {
                JaspiraWizardResultPage.this.process();
                JaspiraWizardResultPage.this.threadAction = 2;
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
                JaspiraWizardResultPage.this.threadAction = 3;
            }
            finally {
                SwingUtilities.invokeLater(JaspiraWizardResultPage.this);
            }
            return Boolean.TRUE;
        }
    }
}

