/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.string.StringUtil;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;

public class GroupOption
extends Option {
    private static final Border BORDER_OUTER = new EmptyBorder(5, 5, 5, 5);
    private static final Border BORDER_INNER = new EmptyBorder(3, 5, 5, 5);

    public GroupOption(ResourceCollection res, String optionName) {
        super(res, optionName, null);
    }

    public GroupOption(String optionName, String displayName, String description, Option parent, int prio) {
        super(optionName, displayName, description, null, "group", parent, prio);
    }

    @Override
    public OptionWidget createOptionWidget() {
        return new GroupWidget();
    }

    @Override
    public String saveToString() {
        return null;
    }

    @Override
    public Object loadFromString(String cryptString) {
        return null;
    }

    public String getDescription() {
        StringBuffer description = new StringBuffer(200);
        boolean group = this.getType().equals("group");
        if (group) {
            StringUtil.append((StringBuffer)description, (String)"<html>", (String)"<head>", (String)"<style type=\"text/css\">", (String)"<!-- body {font-family:Helvetica,Arial,sans-serif;} -->");
            StringUtil.append((StringBuffer)description, (String)"</style>", (String)"</head>", (String)"<body>");
            StringUtil.append((StringBuffer)description, (String)"<b> ", (String)this.getDisplayName(), (String)"</b><br>\n", (String)"<table>\n");
        } else {
            StringUtil.append((StringBuffer)description, (String)"<b> ", (String)this.getDisplayName(), (String)"</b><br>\n", (String)"<table>\n");
        }
        for (Option opt : this.getOptionChildren()) {
            if (opt.getType().equals("option")) {
                StringUtil.append((StringBuffer)description, (String)" <tr><td> ", (String)opt.getDisplayName(), (String)"</td> <td>", (String)opt.getDescription(), (String)" </td></tr>\n");
                continue;
            }
            StringUtil.append((StringBuffer)description, (String)" <tr>", (String)opt.getDescription(), (String)" </td></tr>\n");
        }
        if (group) {
            StringUtil.append((StringBuffer)description, (String)"</table>\n", (String)"</body>", (String)"</html>\n");
        } else {
            description.append("</table>\n");
        }
        return description.toString();
    }

    public class GroupWidget
    extends OptionWidget {
        private Box box;

        public GroupWidget() {
            super(GroupOption.this);
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void setValue(Object o) {
        }

        @Override
        public JComponent getWidgetComponent() {
            if (this.box == null) {
                this.box = Box.createVerticalBox();
                for (Option opt : GroupOption.this.getOptionChildren()) {
                    JComponent comp;
                    OptionWidget widget = opt.getCachedOptionWidget();
                    if (widget == null || (comp = widget.getWidgetComponent()) == null) continue;
                    comp.setOpaque(false);
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setOpaque(false);
                    if (GroupOption.this.getType().equals("subgroup")) {
                        panel.setBorder(BORDER_OUTER);
                    } else {
                        panel.setBorder(new CompoundBorder(BORDER_OUTER, new TitledBorder(opt.getDisplayName())));
                    }
                    comp.setBorder(new CompoundBorder(BORDER_INNER, comp.getBorder()));
                    panel.add(comp);
                    Dimension d = new Dimension(panel.getMaximumSize().width, panel.getMinimumSize().height);
                    panel.setMaximumSize(d);
                    this.box.add(panel);
                    this.box.add(Box.createVerticalStrut(5));
                }
                this.box.add(Box.createVerticalGlue());
            }
            return this.box;
        }
    }
}

