/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionUtil;
import org.openbp.common.setting.SettingUtil;
import org.openbp.jaspira.option.GroupOption;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.option.OptionWidget;

public abstract class Option
extends DisplayObjectImpl
implements TreeNode {
    public static final Comparator priorityComparator = new PriorityComparator();
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_PRIO = "prio";
    public static final String PROPERTY_HEADING = "heading";
    public static final String PROPERTY_OPTION_PARENT = "optionparent";
    public static final String PROPERTY_CONDITION = "condition";
    public static final String TYPE_OPTION = "option";
    public static final String TYPE_GROUP = "group";
    public static final String TYPE_SUB_GROUP = "subgroup";
    public static final int DFLT_PRIORITY = 50;
    private Object value;
    private Object defaultValue;
    private String type;
    private String heading;
    private int prio;
    private String condition;
    private SortedSet optionchildren = new TreeSet(priorityComparator);
    private SortedSet groupchildren = new TreeSet(priorityComparator);
    private Option parent;
    private OptionWidget cachedWidget;

    public Option(ResourceCollection res, String optionName, Object defaultValue) {
        super(optionName);
        ResourceCollectionUtil.loadDisplayObjectFromResource((DisplayObject)this, (ResourceCollection)res, (String)optionName);
        String prefix = optionName != null ? optionName + "." : "";
        this.type = res.getOptionalString(prefix + PROPERTY_TYPE, TYPE_OPTION);
        this.prio = ResourceCollectionUtil.getOptionalInt((ResourceCollection)res, (String)(prefix + PROPERTY_PRIO), (int)50);
        this.condition = res.getOptionalString(prefix + PROPERTY_CONDITION);
        this.heading = res.getOptionalString(prefix + PROPERTY_HEADING);
        String optionParentName = res.getOptionalString(prefix + PROPERTY_OPTION_PARENT, "optionroot");
        OptionMgr optionMgr = OptionMgr.getInstance();
        this.parent = optionMgr.getOption(optionParentName);
        if (this.parent == null) {
            this.parent = new GroupOption(res, optionParentName);
            optionMgr.addOption(this.parent);
        }
        this.parent.addOptionChild(this);
        this.defaultValue = defaultValue;
    }

    public Option(String optionName, String displayName, String description, Object defaultValue, String type, Option parent, int prio) {
        super(optionName, displayName, description);
        this.defaultValue = defaultValue;
        this.prio = prio;
        this.type = type != null ? type : TYPE_GROUP;
        this.parent = parent;
        if (parent != null) {
            parent.addOptionChild(this);
        }
    }

    public void install() {
        OptionMgr.getInstance().addOption(this);
        this.loadOptionValue();
    }

    public void uninstall() {
        OptionMgr.getInstance().removeOption(this);
        this.saveOptionValue();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public abstract OptionWidget createOptionWidget();

    public abstract String saveToString();

    public abstract Object loadFromString(String var1);

    public OptionWidget getCachedOptionWidget() {
        if (this.cachedWidget == null) {
            this.cachedWidget = this.createOptionWidget();
            this.cachedWidget.setValue(this.getValue());
        }
        return this.cachedWidget;
    }

    public void resetCachedOptionWidget() {
        this.cachedWidget = null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getType() {
        return this.type;
    }

    public int getPriority() {
        return this.prio;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getHeading() {
        return this.heading;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getValue() {
        return this.value != null ? this.value : this.getDefaultValue();
    }

    public void setValue(Object o) {
        this.value = o;
        this.saveOptionValue();
    }

    public SortedSet getOptionChildren() {
        return this.optionchildren;
    }

    protected void saveOptionValue() {
        String saveString = this.saveToString();
        SettingUtil.setStringSetting((String)this.getName(), (String)saveString);
    }

    protected Object loadOptionValue() {
        String s = SettingUtil.getStringSetting((String)this.getName());
        if (s != null) {
            this.value = this.loadFromString(s);
        }
        return this.value == null ? this.getDefaultValue() : this.value;
    }

    protected void addOptionChild(Option opt) {
        if (opt.getType().equals(TYPE_GROUP)) {
            this.groupchildren.add(opt);
        } else {
            this.optionchildren.add(opt);
        }
    }

    protected void removeOptionChild(Option opt) {
        if (opt.getType().equals(TYPE_GROUP)) {
            this.groupchildren.remove(opt);
        } else {
            this.optionchildren.remove(opt);
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        Iterator it = this.groupchildren.iterator();
        TreeNode node = (TreeNode)it.next();
        for (int i = 0; i < childIndex; ++i) {
            node = (TreeNode)it.next();
        }
        return node;
    }

    @Override
    public int getChildCount() {
        return this.groupchildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        int count = 0;
        Iterator it = this.groupchildren.iterator();
        while (it.hasNext()) {
            if (node == it.next()) {
                return count;
            }
            ++count;
        }
        return count;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.groupchildren.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.groupchildren);
    }

    private static class PriorityComparator
    implements Comparator {
        private PriorityComparator() {
        }

        public int compare(Object o1, Object o2) {
            String n2;
            Option a1 = (Option)o1;
            Option a2 = (Option)o2;
            int result = a1.getPriority() - a2.getPriority();
            if (result != 0) {
                return result;
            }
            String n1 = a1.getDisplayName();
            if (n1 == null) {
                n1 = a1.getName();
            }
            if ((n2 = a2.getDisplayName()) == null) {
                n2 = a2.getName();
            }
            return n1.compareTo(n2);
        }
    }
}

