/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.swing.components.JMsgBox;
import org.openbp.swing.components.tree.TreeUtil;
import org.openbp.swing.plaf.sky.ShadowBorder;

public class OptionDialog
extends JDialog {
    private static final Dimension SIZE = new Dimension(800, 600);
    private static final EmptyBorder BORDER_PAGE = new EmptyBorder(3, 3, 3, 3);
    private static final EmptyBorder BORDER_TREE = new EmptyBorder(2, 3, 2, 0);
    private ResourceCollection resourceCollection;
    private JTree tree;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton applyBtn;
    private JScrollPane widgetScrollPane;
    private JScrollPane descriptionScrollPane;
    private Map modifiedOptions;

    public OptionDialog(String title) {
        super(ApplicationUtil.getActiveWindow(), title, true);
        this.setSize(SIZE);
        this.setLocationRelativeTo(this.getOwner());
        this.resourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("common", JMsgBox.class);
        JScrollPane treeScrollPane = new JScrollPane();
        treeScrollPane.setBorder((Border)new ShadowBorder());
        this.widgetScrollPane = new JScrollPane();
        this.widgetScrollPane.setBorder((Border)new ShadowBorder());
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionScrollPane.setBorder((Border)new ShadowBorder());
        this.okBtn = this.createButton("buttons.ok.caption");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.optionDialogCommitted();
                OptionDialog.this.optionDialogClosed();
                OptionDialog.this.close();
            }
        });
        this.okBtn.setEnabled(false);
        this.cancelBtn = this.createButton("buttons.cancel.caption");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.optionDialogCancelled();
                OptionDialog.this.close();
            }
        });
        this.applyBtn = this.createButton("buttons.apply.caption");
        this.applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.optionDialogCommitted();
            }
        });
        this.applyBtn.setEnabled(false);
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder((Border)new ShadowBorder());
        btnPanel.add(this.okBtn);
        btnPanel.add(this.applyBtn);
        btnPanel.add(this.cancelBtn);
        JSplitPane horizontalSplit = new JSplitPane(0);
        JSplitPane verticalSplit = new JSplitPane(1);
        horizontalSplit.setTopComponent(verticalSplit);
        horizontalSplit.setBottomComponent(this.descriptionScrollPane);
        horizontalSplit.setDividerLocation(400);
        verticalSplit.setLeftComponent(treeScrollPane);
        verticalSplit.setRightComponent(this.widgetScrollPane);
        verticalSplit.setDividerLocation(200);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)btnPanel, "South");
        contentPane.add(horizontalSplit);
        this.tree = new JTree(OptionMgr.getInstance().createOptionTree());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        TreeSelectionListener selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Option option = (Option)e.getPath().getLastPathComponent();
                OptionWidget widget = option.getCachedOptionWidget();
                OptionDialog.this.setPageComponent(widget.getWidgetComponent());
                OptionDialog.this.setDescription(widget.getDescriptionComponent());
            }
        };
        this.tree.addTreeSelectionListener(selectionListener);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    if (value instanceof Option) {
                        Option opt = (Option)value;
                        label.setIcon(opt.getIcon());
                        label.setToolTipText(opt.getDescription());
                    } else {
                        label.setIcon(null);
                    }
                    label.setBorder(BORDER_TREE);
                }
                return c;
            }
        };
        this.tree.setCellRenderer(renderer);
        treeScrollPane.getViewport().setView(this.tree);
        TreeUtil.expandTreeLevels((JTree)this.tree, (boolean)true, (int)2);
        this.tree.setRootVisible(false);
        TreePath firstPath = this.tree.getPathForRow(0);
        if (firstPath != null) {
            this.tree.setSelectionPath(firstPath);
        }
        contentPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "exit");
        contentPane.getActionMap().put("exit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionDialog.this.optionDialogCancelled();
                OptionDialog.this.close();
            }
        });
        this.setContentPane(contentPane);
        OptionMgr.getInstance().fireEvent("optiondialog.displayed");
    }

    private JButton createButton(String name) {
        String text = this.resourceCollection.getRequiredString(name);
        int mnemonicpos = text.indexOf(95);
        if (mnemonicpos != -1) {
            text = text.substring(0, mnemonicpos) + text.substring(mnemonicpos + 1);
        }
        JButton button = new JButton(text);
        if (mnemonicpos > -1) {
            button.setDisplayedMnemonicIndex(mnemonicpos);
            button.setMnemonic(text.charAt(mnemonicpos));
        }
        return button;
    }

    protected void close() {
        this.dispose();
    }

    public void setDescription(JComponent comp) {
        comp.setBorder(BORDER_PAGE);
        if (comp instanceof JTextComponent) {
            ((JTextComponent)comp).setCaretPosition(0);
        }
        this.descriptionScrollPane.getViewport().setView(comp);
    }

    public void setPageComponent(JComponent comp) {
        comp.setBorder(BORDER_PAGE);
        this.widgetScrollPane.getViewport().setView(comp);
    }

    public void notifyOptionChange(OptionWidget widget) {
        if (this.modifiedOptions == null) {
            this.modifiedOptions = new HashMap();
        }
        this.modifiedOptions.put(widget, widget);
        this.applyBtn.setEnabled(true);
        this.okBtn.setEnabled(true);
    }

    void optionDialogCommitted() {
        if (this.modifiedOptions == null) {
            return;
        }
        OptionMgr optionMgr = OptionMgr.getInstance();
        for (OptionWidget widget : this.modifiedOptions.values()) {
            Option option = widget.getOption();
            Object value = widget.getValue();
            optionMgr.setOption(option, value);
        }
        this.modifiedOptions = null;
        optionMgr.saveOptions();
        optionMgr.fireEvent("optiondialog.commit");
    }

    void optionDialogCancelled() {
        this.modifiedOptions = null;
        OptionMgr.getInstance().fireEvent("optiondialog.cancelled");
    }

    void optionDialogClosed() {
        this.modifiedOptions = null;
        OptionMgr.getInstance().fireEvent("optiondialog.closed");
    }
}

