/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option;

import java.util.ArrayList;
import org.openbp.common.CommonUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.jaspira.option.LocalizableOptionString;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.option.widget.SelectionWidget;

public class SelectionOption
extends Option {
    private String[] valueNames;
    private Object[] values;
    private ResourceCollection resourceCollection;

    public SelectionOption(ResourceCollection res, String optionName, Object defaultValue, String[] valueNames, Object[] values) {
        super(res, optionName, defaultValue);
        this.resourceCollection = res;
        this.valueNames = valueNames;
        this.values = values;
    }

    @Override
    public OptionWidget createOptionWidget() {
        ArrayList<LocalizableOptionString> selectionValues = new ArrayList<LocalizableOptionString>();
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                String text = this.resourceCollection.getOptionalString(this.getName() + ".values." + this.valueNames[i], this.valueNames[i]);
                selectionValues.add(new LocalizableOptionString(text, this.values[i]));
            }
        }
        return new SelectionWidget(this, selectionValues);
    }

    @Override
    public String saveToString() {
        Object value = this.getValue();
        if (value == null || CommonUtil.equalsNull((Object)value, (Object)this.getDefaultValue())) {
            return null;
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!value.equals(this.values[i])) continue;
                return this.valueNames[i];
            }
        }
        return null;
    }

    @Override
    public Object loadFromString(String s) {
        if (s != null && this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!s.equals(this.valueNames[i])) continue;
                return this.values[i];
            }
        }
        return this.getDefaultValue();
    }
}

