/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugins.colorchooser.DefaultPreviewPanel;
import org.openbp.swing.components.JStandardDialog;
import org.openbp.swing.layout.UnitLayout;
import org.openbp.swing.plaf.sky.ShadowBorder;

public class ColorDialog
extends JStandardDialog {
    private Color selectedColor;
    private JColorChooser colorChooser;
    private DefaultPreviewPanel preview;
    private static final int PALETTE_DIMENSION = 200;
    private static final Dimension PREVIEW_SIZE = new Dimension(50, 203);

    public ColorDialog() {
        super((Frame)ApplicationUtil.getActiveWindow(), true);
        this.setTitle("Select Color");
        this.colorChooser = new JColorChooser();
        this.colorChooser.setBorder(new EmptyBorder(7, 0, 0, 0));
        this.preview = new DefaultPreviewPanel();
        this.preview.setMinimumSize(PREVIEW_SIZE);
        this.preview.setMaximumSize(PREVIEW_SIZE);
        this.preview.setPreferredSize(PREVIEW_SIZE);
        this.preview.setSize(PREVIEW_SIZE);
        this.preview.setBorder((Border)new ShadowBorder());
        this.preview.setAlignmentX(1.0f);
        this.colorChooser.setPreviewPanel(this.preview);
        JPanel previewPanel = new JPanel((LayoutManager)new UnitLayout(2, 1));
        previewPanel.setBorder(new EmptyBorder(40, 5, 5, 10));
        previewPanel.add(this.preview);
        JPanel chooserPanel = new JPanel(new BorderLayout());
        chooserPanel.add("Center", this.colorChooser);
        chooserPanel.add("West", previewPanel);
        this.getMainPane().add(chooserPanel);
        this.pack();
    }

    protected void handleOk() {
        super.handleOk();
        this.selectedColor = this.colorChooser.getColor();
    }

    public void setColor(Color color) {
        this.colorChooser.setColor(color);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }
}

