/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;
import org.openbp.jaspira.option.widget.ColorDialog;
import org.openbp.swing.plaf.sky.SimpleBorder;
import org.openbp.swing.plaf.sky.SkyTheme;

public class ColorWidget
extends OptionWidget {
    private JPanel panel;
    private JTextField colorField = new JTextField();
    private ColorDialog colorChooser;

    public ColorWidget(Option option) {
        super(option);
        this.colorField.setEditable(false);
        this.colorField.setBorder((Border)SimpleBorder.getStandardBorder());
        this.colorField.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
        Dimension size = this.colorField.getPreferredSize();
        size.width = 100;
        size.height = 18;
        this.colorField.setPreferredSize(size);
        this.colorField.setMinimumSize(size);
        this.colorField.setMaximumSize(size);
        this.colorField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                ColorWidget.this.colorField.postActionEvent();
            }
        });
        this.colorField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorWidget.this.colorChooser == null) {
                    ColorWidget.this.colorChooser = new ColorDialog();
                }
                ColorWidget.this.colorChooser.setColor(ColorWidget.this.colorField.getBackground());
                ColorWidget.this.colorChooser.setVisible(true);
                Color color = ColorWidget.this.colorChooser.getSelectedColor();
                if (color != null) {
                    ColorWidget.this.colorField.setBackground(color);
                    ColorWidget.this.notifyOptionMgrOfOptionChange();
                }
            }
        });
        JButton resetButton = new JButton();
        resetButton.setBorder((Border)SimpleBorder.getStandardBorder());
        resetButton.setText("Reset");
        size = resetButton.getPreferredSize();
        size.height = 18;
        resetButton.setPreferredSize(size);
        resetButton.setMinimumSize(size);
        resetButton.setMaximumSize(size);
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = (Color)ColorWidget.this.getOption().getDefaultValue();
                if (color != null) {
                    ColorWidget.this.colorField.setBackground(color);
                    ColorWidget.this.notifyOptionMgrOfOptionChange();
                }
            }
        });
        this.panel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel heading = this.createHeading();
        if (heading != null) {
            this.panel.add(heading);
        }
        this.panel.add(this.colorField);
        this.panel.add(resetButton);
    }

    @Override
    public Object getValue() {
        return this.colorField.getBackground();
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.panel;
    }

    @Override
    public void setValue(Object o) {
        if (o != null && o instanceof Color) {
            this.colorField.setBackground((Color)o);
        }
    }
}

