/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.option.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionWidget;

public class TextWidget
extends OptionWidget
implements DocumentListener {
    private JPanel panel;
    private JTextField textField;

    public TextWidget(Option option, int numberOfCharacters) {
        this(option, numberOfCharacters, new DefaultStyledDocument());
    }

    public TextWidget(Option option, int numberOfCharacters, Document doc) {
        super(option);
        this.textField = new JTextField(doc, (String)option.getValue(), numberOfCharacters);
        this.textField.getDocument().addDocumentListener(this);
        this.panel = new JPanel(new BorderLayout());
        JLabel heading = this.createHeading();
        if (heading != null) {
            this.panel.add((Component)heading, "West");
        }
        this.panel.add(this.textField);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyOptionMgrOfOptionChange();
    }

    @Override
    public Object getValue() {
        return this.textField.getText();
    }

    @Override
    public void setValue(Object o) {
        this.textField.setText(o != null ? o.toString() : null);
    }

    @Override
    public JComponent getWidgetComponent() {
        return this.panel;
    }
}

