/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugin;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbp.common.ExceptionUtil;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.JaspiraEventListener;

public abstract class EventModule
implements JaspiraEventListener {
    public static final int MODULE_TREE = 0;
    public static final int MODULE_PRE_GLOBAL = 1;
    public static final int MODULE_POST_GLOBAL = 2;
    public static final JaspiraEventHandlerCode EVENT_IGNORED = new JaspiraEventHandlerCode("ignored");
    public static final JaspiraEventHandlerCode EVENT_HANDLED = new JaspiraEventHandlerCode("handled");
    public static final JaspiraEventHandlerCode EVENT_CONSUMED = new JaspiraEventHandlerCode("consumed");
    private Map eventMethods = new HashMap();
    private List actionEventNames;
    private List foreignEventNames;

    public EventModule() {
        this.readEvents();
    }

    public abstract String getName();

    public List getForeignEventNames() {
        return this.foreignEventNames;
    }

    public List getEventActionNames() {
        return this.actionEventNames;
    }

    public int getModuleType() {
        return 0;
    }

    private void readEvents() {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> paramType;
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (method.getReturnType() != JaspiraEventHandlerCode.class || (paramTypes = method.getParameterTypes()).length != 1 || !JaspiraEvent.class.isAssignableFrom(paramType = paramTypes[0])) continue;
            String name = method.getName().toLowerCase();
            if (name.indexOf(95) < 0) {
                name = this.getName() + "." + name;
            } else {
                String suffix;
                name = name.replace('_', '.');
                boolean addToForeignEventList = true;
                if (name.startsWith(this.getName() + ".") && (suffix = name.substring(this.getName().length() + 1)).indexOf(46) < 0) {
                    System.err.println("Foreign event should be local: " + name + " in module " + this.getClass().getName());
                    addToForeignEventList = false;
                }
                if (addToForeignEventList) {
                    if (this.foreignEventNames == null) {
                        this.foreignEventNames = new ArrayList();
                    }
                    this.foreignEventNames.add(name);
                }
            }
            this.eventMethods.put(name, method);
            if (paramType != JaspiraActionEvent.class) continue;
            if (this.actionEventNames == null) {
                this.actionEventNames = new ArrayList();
            }
            this.actionEventNames.add(name);
        }
    }

    protected JaspiraEventHandlerCode handleUnaccountedEvent(JaspiraEvent pe) {
        return EVENT_IGNORED;
    }

    @Override
    public boolean eventFired(JaspiraEvent je) {
        JaspiraEventHandlerCode result = null;
        String eventname = je.getEventName();
        Method method = (Method)this.eventMethods.get(eventname);
        if (method != null) {
            try {
                result = (JaspiraEventHandlerCode)method.invoke((Object)this, je);
            }
            catch (Exception e) {
                System.err.println("Error invoking event method " + method.getDeclaringClass().getName() + "." + method.getName() + ":");
                ExceptionUtil.printTrace((Throwable)e);
                return true;
            }
        } else {
            result = this.handleUnaccountedEvent(je);
        }
        return je.updateFlags(result);
    }

    @Override
    public int getPriority() {
        return 50;
    }
}

