/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.plugin.ConfigMgr;

public abstract class OptionModule {
    private List options;

    public final void install() {
        this.loadOptions();
    }

    public final void uninstall() {
        if (this.options != null) {
            int n = this.options.size();
            for (int i = 0; i < n; ++i) {
                Option option = (Option)this.options.get(i);
                option.uninstall();
            }
            this.options = null;
        }
    }

    public List getExternalOptionClasses() {
        return null;
    }

    protected final void loadOptions() {
        Class<?>[] innerClasses = this.getClass().getClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            if (!Option.class.isAssignableFrom(innerClasses[i]) || Modifier.isAbstract(innerClasses[i].getModifiers())) continue;
            try {
                Constructor<?> contr = innerClasses[i].getDeclaredConstructors()[0];
                Option option = (Option)contr.newInstance(this);
                this.addOption(option);
                continue;
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            catch (ClassCastException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
        List externalOptions = this.getExternalOptionClasses();
        if (externalOptions != null) {
            for (Class cls : externalOptions) {
                if (!Option.class.isAssignableFrom(cls)) continue;
                Option option = (Option)ReflectUtil.instantiate((Class)cls, Option.class, (String)"external option");
                this.addOption(option);
            }
        }
    }

    private void addOption(Option option) {
        if (!ConfigMgr.getInstance().evaluate(option.getCondition())) {
            return;
        }
        option.install();
        if (this.options == null) {
            this.options = new ArrayList();
        }
        this.options.add(option);
    }
}

