/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugins.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.icon.MultiImageIcon;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.gui.plugin.AbstractVisiblePlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugins.colorchooser.DefaultPreviewPanel;
import org.openbp.swing.layout.UnitLayout;
import org.openbp.swing.layout.VerticalFlowLayout;
import org.openbp.swing.plaf.sky.ShadowBorder;
import org.openbp.swing.plaf.sky.SkyTheme;

public class ColorChooserPlugin
extends AbstractVisiblePlugin
implements HierarchyListener {
    private static final int PALETTE_DIMENSION = 200;
    private static final Dimension PREVIEW_SIZE = new Dimension(50, 203);
    private JColorChooser chooser;
    private DefaultPreviewPanel preview;
    private JTextArea helpTextArea;
    private JPanel mainPanel;
    private String helpText;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    @Override
    protected void initializeComponents() {
    }

    protected void doInit() {
        if (this.chooser != null && this.getContentPane().isShowing()) {
            return;
        }
        this.chooser = new JColorChooser();
        AbstractColorChooserPanel[] panels = this.chooser.getChooserPanels();
        for (int i = 0; i < panels.length; ++i) {
            if (panels[i].getClass().getName().endsWith("HSBChooserPanel")) continue;
            this.chooser.removeChooserPanel(panels[i]);
        }
        this.chooser.setBorder(new EmptyBorder(7, 0, 0, 0));
        this.preview = new DefaultPreviewPanel();
        this.preview.setMinimumSize(PREVIEW_SIZE);
        this.preview.setMinimumSize(PREVIEW_SIZE);
        this.preview.setMaximumSize(PREVIEW_SIZE);
        this.preview.setPreferredSize(PREVIEW_SIZE);
        this.preview.setSize(PREVIEW_SIZE);
        this.preview.setBorder((Border)new ShadowBorder());
        this.chooser.setPreviewPanel(this.preview);
        this.helpTextArea = new JTextArea(2, 0);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setWrapStyleWord(true);
        this.helpTextArea.setBorder(new EmptyBorder(0, 10, 10, 5));
        this.helpTextArea.setText(this.helpText);
        JPanel previewPanel = new JPanel((LayoutManager)new UnitLayout(2, 1));
        previewPanel.setBorder(new EmptyBorder(19, 5, 5, 5));
        previewPanel.add(this.preview);
        JPanel chooserPanel = new JPanel(new BorderLayout());
        chooserPanel.add("Center", this.chooser);
        chooserPanel.add("West", previewPanel);
        Dimension chooserSize = chooserPanel.getPreferredSize();
        this.helpTextArea.setPreferredSize(new Dimension(chooserSize.width, 0));
        this.mainPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.mainPanel.add(chooserPanel);
        this.mainPanel.add(this.helpTextArea);
        this.setComponentBackground(this.mainPanel, SkyTheme.COLOR_BACKGROUND_LIGHT);
        final JScrollPane sp = new JScrollPane(this.mainPanel);
        this.getContentPane().add(sp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sp.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    @Override
    public void pluginShown() {
        super.pluginShown();
        this.doInit();
    }

    private void setComponentBackground(Component comp, Color background) {
        comp.setBackground(background);
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.setComponentBackground(comps[i], background);
            }
        }
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
        if (this.helpTextArea != null) {
            this.helpTextArea.setText(helpText);
        }
    }

    public static MultiIcon createColorDragIcon(Color color) {
        BufferedImage image = new BufferedImage(32, 32, 2);
        Graphics g = image.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setColor(color);
        g.fillRoundRect(0, 0, 31, 31, 16, 16);
        g.setColor(Color.BLACK);
        g.drawRoundRect(0, 0, 31, 31, 16, 16);
        return new MultiImageIcon(new ImageIcon(image));
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "colorchooser";
        }

        public JaspiraEventHandlerCode setcolor(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof Color) {
                Color color = (Color)o;
                if (ColorChooserPlugin.this.chooser != null) {
                    ColorChooserPlugin.this.chooser.setColor(color);
                }
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode sethelptext(JaspiraEvent je) {
            Object o = je.getObject();
            if (o instanceof String) {
                ColorChooserPlugin.this.setHelpText((String)o);
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }
    }
}

