/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.plugins.colorchooser;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import javax.swing.JPanel;
import org.openbp.common.icon.MultiIcon;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.gui.interaction.DragInitiator;
import org.openbp.jaspira.gui.interaction.DragOrigin;
import org.openbp.jaspira.plugins.colorchooser.ColorChooserPlugin;

public class DefaultPreviewPanel
extends JPanel
implements DragOrigin {
    private MultiIcon dragIcon;

    public DefaultPreviewPanel() {
        DragInitiator.makeDraggable(this, this);
        this.dragIcon = ColorChooserPlugin.createColorDragIcon(this.getForeground());
    }

    @Override
    public boolean canDrag() {
        return true;
    }

    @Override
    public void dropAccepted(Transferable t) {
    }

    @Override
    public void dropCanceled(Transferable t) {
    }

    @Override
    public void dropPerformed(Transferable t) {
    }

    @Override
    public Transferable getTranferableAt(Point p) {
        return this.getTransferable();
    }

    @Override
    public MultiIcon getDragImage() {
        return this.dragIcon;
    }

    public Transferable getTransferable() {
        return new BasicTransferable(this.getForeground());
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.dragIcon = ColorChooserPlugin.createColorDragIcon(color);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getForeground());
        Insets insets = this.getInsets();
        g.fillRect(insets.left - 2, insets.top - 2, this.getWidth() - insets.left - insets.right + 4, this.getHeight() - insets.top - insets.bottom + 4);
    }
}

