/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbp.common.ReflectUtil;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;
import org.openbp.jaspira.propertybrowser.editor.PropertyValidator;

public final class PropertyEditorMgr {
    private List packages;
    private Map editors = new HashMap();
    private Map validators = new HashMap();
    private static PropertyEditorMgr singletonInstance;

    private PropertyEditorMgr() {
        this.addPackage("org.openbp.jaspira.propertybrowser.editor.standard");
    }

    public static synchronized PropertyEditorMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new PropertyEditorMgr();
        }
        return singletonInstance;
    }

    public static void reset() {
        PropertyEditorMgr.getInstance().editors.clear();
        PropertyEditorMgr.getInstance().validators.clear();
    }

    public void addPackage(String pkg) {
        if (this.packages == null) {
            this.packages = new ArrayList();
        }
        this.packages.add(pkg);
    }

    public Class findPropertyEditor(String className) {
        Class cls = (Class)this.editors.get(className);
        if (cls == null) {
            cls = ReflectUtil.findClassInPackageList((String)className, (List)this.packages);
            if (cls != null) {
                if (PropertyEditor.class.isAssignableFrom(cls)) {
                    this.editors.put(className, cls);
                } else {
                    System.err.println("Property editor '" + cls.getName() + "' does not implement the PropertyEditor interface");
                    cls = null;
                }
            } else {
                System.err.println("Property editor '" + className + "' not found");
            }
        }
        return cls;
    }

    public Class findPropertyValidator(String className) {
        Class cls = (Class)this.validators.get(className);
        if (cls == null) {
            cls = ReflectUtil.findClassInPackageList((String)className, (List)this.packages);
            if (cls != null) {
                if (PropertyValidator.class.isAssignableFrom(cls)) {
                    this.validators.put(className, cls);
                } else {
                    System.err.println("Property validator '" + cls.getName() + "' does not implement the PropertyValidator interface");
                    cls = null;
                }
            } else {
                System.err.println("Property validator '" + className + "' not found");
            }
        }
        return cls;
    }
}

