/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.editor.standard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.string.shellmatcher.ShellMatcher;
import org.openbp.jaspira.propertybrowser.editor.EditorParameterParser;
import org.openbp.jaspira.propertybrowser.editor.standard.PathEditorCustomizer;
import org.openbp.jaspira.propertybrowser.editor.standard.StringEditor;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class PathEditor
extends StringEditor {
    private String title;
    private String type;
    private List filterList;
    private boolean dirSelection;
    private String customizerClassName;
    private PathEditorCustomizer customizer;

    @Override
    public void createComponent() {
        super.createComponent();
        if (!this.readonly) {
            int h;
            BasicArrowButton btn = new BasicArrowButton(5);
            btn.setBorder((Border)new SimpleBorder(0, 2, 0, 2));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathEditor.this.showBrowser();
                }
            });
            btn.setEnabled(true);
            btn.setFocusable(false);
            btn.setRequestFocusEnabled(false);
            Dimension size = new Dimension(((JComponent)btn).getMinimumSize());
            size.height = h = this.textField.getHeight();
            btn.setMinimumSize(size);
            btn.setMaximumSize(size);
            btn.setPreferredSize(size);
            this.component = new EditorPanel(this.textField, btn);
        }
    }

    @Override
    public void highlight(boolean on) {
        boolean show;
        boolean bl = show = on && this.textField.hasFocus();
        if (show) {
            this.textField.setSelectionStart(0);
            int length = this.textField.getText().length();
            this.textField.setSelectionEnd(length);
        } else {
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(0);
        }
        this.textField.getCaret().setVisible(show);
        this.textField.getCaret().setSelectionVisible(show);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PathEditor.this.textField.repaint();
            }
        });
    }

    @Override
    protected void parseParams(EditorParameterParser parser) {
        this.title = parser.getString("title");
        if (this.title == null) {
            this.title = "File Selection";
        }
        this.type = parser.getString("type");
        String s = parser.getString("dirselection");
        this.dirSelection = "true".equals(s);
        Iterator iter = parser.get("filter");
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String description = EditorParameterParser.determineDisplayValue(param);
            String pattern = EditorParameterParser.determineInternalValue(param);
            if (this.filterList == null) {
                this.filterList = new ArrayList();
            }
            this.filterList.add(new PatternFileFilter(pattern, description));
        }
        this.customizerClassName = parser.getString("customizer");
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 10: 
            case 32: 
            case 40: {
                if (!e.isControlDown() && !e.isAltDown() && !e.isAltGraphDown()) break;
                this.showBrowser();
                e.consume();
                return;
            }
        }
        super.keyPressed(e);
    }

    public void showBrowser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(this.title);
        fileChooser.setFileHidingEnabled(true);
        if (this.dirSelection) {
            fileChooser.setFileSelectionMode(1);
        } else {
            fileChooser.setFileSelectionMode(2);
        }
        if (this.type != null) {
            if (this.type.equals("open")) {
                fileChooser.setDialogType(0);
            } else if (this.type.equals("save")) {
                fileChooser.setDialogType(1);
            } else {
                fileChooser.setDialogType(2);
                fileChooser.setApproveButtonText(this.type);
            }
        } else {
            fileChooser.setDialogType(0);
        }
        if (this.filterList != null) {
            int n = this.filterList.size();
            for (int i = 0; i < n; ++i) {
                FileFilter filter = (FileFilter)this.filterList.get(i);
                fileChooser.addChoosableFileFilter(filter);
                if (i != 0) continue;
                fileChooser.setFileFilter(filter);
            }
        }
        if (this.customizer == null && this.customizerClassName != null) {
            try {
                this.customizer = (PathEditorCustomizer)ReflectUtil.instantiate((String)this.customizerClassName, PathEditorCustomizer.class, (String)"component selection editor customizer class");
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
        String[] pathRef = new String[]{(String)this.value};
        if (this.customizer != null && !this.customizer.initializeChooser(this, fileChooser, pathRef)) {
            return;
        }
        if (pathRef[0] != null) {
            File f = new File(pathRef[0]);
            if (f.exists()) {
                fileChooser.setSelectedFile(f);
            }
            if (!f.isDirectory()) {
                f = f.getParentFile();
            }
            fileChooser.setCurrentDirectory(f);
        }
        if (this.customizer != null && !this.customizer.chooserInitialized(this, fileChooser, pathRef)) {
            return;
        }
        int retVal = fileChooser.showOpenDialog(null);
        if (retVal == 0) {
            pathRef[0] = fileChooser.getSelectedFile().getPath();
        }
        if (this.customizer != null && !this.customizer.chooserClosed(this, fileChooser, pathRef)) {
            return;
        }
        if (retVal == 0) {
            this.textField.setText(pathRef[0]);
            this.textField.requestFocus();
            this.propertyChanged();
        }
    }

    private static class PatternFileFilter
    extends FileFilter {
        private String pattern;
        private String description;
        private ShellMatcher matcher;

        public PatternFileFilter(String pattern, String description) {
            this.pattern = pattern;
            this.description = description;
            this.matcher = new ShellMatcher(pattern);
            this.matcher.setIgnoreCase(true);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return this.matcher == null || this.matcher.match(name);
        }

        @Override
        public String getDescription() {
            if (this.description != null) {
                return this.description;
            }
            return this.pattern;
        }
    }

    private static class EditorPanel
    extends JPanel {
        JTextField textField;

        public EditorPanel(JTextField textField, JButton btn) {
            super(new BorderLayout());
            this.setFocusable(false);
            this.textField = textField;
            textField.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 0, 2), textField.getBorder()));
            this.add((Component)textField, "Center");
            this.add((Component)btn, "East");
        }

        @Override
        public void requestFocus() {
            this.textField.requestFocus();
        }
    }
}

