/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.nodes;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.generic.description.Displayable;
import org.openbp.common.generic.propertybrowser.ObjectDescriptor;
import org.openbp.common.generic.propertybrowser.ObjectDescriptorMgr;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.property.PropertyAccessUtil;
import org.openbp.common.property.PropertyException;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.propertybrowser.ObjectValidator;
import org.openbp.jaspira.propertybrowser.PropertyBrowserModel;
import org.openbp.jaspira.propertybrowser.nodes.AbstractNode;
import org.openbp.jaspira.propertybrowser.nodes.CollectionNode;
import org.openbp.jaspira.propertybrowser.nodes.GroupNode;
import org.openbp.jaspira.propertybrowser.nodes.PropertyNode;
import org.openbp.swing.components.treetable.JTreeTable;

public class ObjectNode
extends AbstractNode {
    private ObjectDescriptor objectDescriptor;
    private PropertyDescriptor propertyDescriptor;
    private ObjectValidator validator;

    public ObjectNode(ObjectDescriptor objectDescriptor) {
        this.objectDescriptor = objectDescriptor;
        this.initialize();
    }

    public ObjectNode(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public String toString() {
        if (this.propertyDescriptor != null) {
            return ToStringHelper.toString((Object)this, (String)"propertyDescriptor.name", (String)"objectDescriptor.objectClassName");
        }
        return ToStringHelper.toString((Object)this, (String)"objectDescriptor.objectClassName");
    }

    @Override
    public void reload() {
        this.children = null;
        this.initialize();
        super.reload();
    }

    @Override
    public boolean representsProperty(String propertyName) {
        return this.propertyDescriptor != null && this.propertyDescriptor.getName().equals(propertyName);
    }

    public void initialize() {
        if (this.children == null && this.objectDescriptor != null) {
            this.children = new Vector();
            Iterator it = this.objectDescriptor.getProperties();
            while (it.hasNext()) {
                this.addProperty((PropertyDescriptor)it.next());
            }
            this.createValidator();
        }
    }

    private void createValidator() {
        if (this.validator != null) {
            return;
        }
        String validatorClassName = this.objectDescriptor.getValidatorClassName();
        if (validatorClassName != null) {
            Class cls = this.objectDescriptor.getValidatorClass();
            if (cls == null) {
                cls = ReflectUtil.loadClass((String)validatorClassName);
                if (cls != null) {
                    if (ObjectValidator.class.isAssignableFrom(cls)) {
                        this.objectDescriptor.setValidatorClass(cls);
                    } else {
                        System.err.println("Object validator '" + validatorClassName + "' does not implement the ObjectValidator interface");
                        cls = null;
                    }
                } else {
                    System.err.println("Object validator '" + validatorClassName + "' not found");
                }
            }
            try {
                this.validator = (ObjectValidator)ReflectUtil.instantiate((Class)cls, ObjectValidator.class, (String)"object validator");
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        ObjectNode src = (ObjectNode)source;
        this.objectDescriptor = src.objectDescriptor;
        this.propertyDescriptor = src.propertyDescriptor;
        this.validator = src.validator;
    }

    public String getNodeText() {
        if (this.propertyDescriptor != null) {
            return this.propertyDescriptor.getDisplayName();
        }
        if (this.object != null) {
            if (this.object instanceof DisplayObjectImpl) {
                String value = ((DisplayObjectImpl)this.object).getDisplayText();
                return value;
            }
            if (this.object instanceof DisplayObject) {
                String value = ((DisplayObject)this.object).getDisplayName();
                if (value == null) {
                    value = ((DisplayObject)this.object).getName();
                }
                return value;
            }
            if (this.object instanceof Displayable) {
                String value = ((Displayable)this.object).getDisplayText();
                return value;
            }
        }
        if (this.objectDescriptor != null) {
            return this.objectDescriptor.getDisplayName();
        }
        return null;
    }

    public Object getColumnValue(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.propertyDescriptor != null) {
                    return this.propertyDescriptor;
                }
                if (this.object != null) {
                    return this.object;
                }
                if (this.objectDescriptor != null) {
                    return this.objectDescriptor;
                }
                return null;
            }
            case 1: {
                if (this.propertyDescriptor != null) {
                    return JTreeTable.createDescriptionCellValue((String)this.propertyDescriptor.getDescription());
                }
                if (this.object != null) {
                    if (this.object instanceof DisplayObject) {
                        return JTreeTable.createDescriptionCellValue((String)((DisplayObject)this.object).getDescriptionText());
                    }
                    return this.object.toString();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean shouldExpand() {
        if (this.propertyDescriptor != null) {
            return super.shouldExpand();
        }
        return this.parentNode == null;
    }

    @Override
    public void setObject(Object object) {
        if (this.propertyDescriptor != null && object != null) {
            try {
                object = PropertyAccessUtil.getProperty((Object)object, (String)this.propertyDescriptor.getName());
            }
            catch (PropertyException e) {
                ExceptionUtil.printTrace((Throwable)e);
                return;
            }
            if (object == null) {
                AbstractNode parent = (AbstractNode)((Object)this.getParent());
                if (parent.children != null) {
                    parent.children.remove(this);
                    if (this.propertyBrowser != null) {
                        ((PropertyBrowserModel)((Object)this.propertyBrowser.getModel())).fireNodeRemoved((TreeNode)((Object)parent));
                    }
                }
                return;
            }
            Class<?> cls = object.getClass();
            try {
                this.objectDescriptor = ObjectDescriptorMgr.getInstance().getDescriptor(cls, 1);
                this.initialize();
                this.setPropertyBrowser(this.propertyBrowser);
            }
            catch (XMLDriverException ex) {
                ExceptionUtil.printTrace((Throwable)ex);
                return;
            }
        }
        this.initialize();
        super.setObject(object);
    }

    public ObjectDescriptor getObjectDescriptor() {
        return this.objectDescriptor;
    }

    public void setObjectDescriptor(ObjectDescriptor objectDescriptor) {
        this.objectDescriptor = objectDescriptor;
    }

    public ObjectValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ObjectValidator validator) {
        this.validator = validator;
    }

    protected void addProperty(PropertyDescriptor pd) {
        String groupName = pd.getGroup();
        if (groupName == null) {
            ObjectNode.addPropertyNode(pd, this);
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                GroupNode groupNode;
                Object node = this.children.get(i);
                if (!(node instanceof GroupNode) || !(groupNode = (GroupNode)node).getGroupName().equals(groupName)) continue;
                ObjectNode.addPropertyNode(pd, groupNode);
                return;
            }
            GroupNode groupNode = new GroupNode(groupName);
            ObjectNode.addPropertyNode(pd, groupNode);
            this.add(groupNode);
        }
    }

    private static void addPropertyNode(PropertyDescriptor pd, AbstractNode parent) {
        AbstractNode node = pd.getCollectionDescriptor() != null ? new CollectionNode(pd) : (pd.getComplexProperty() != null ? new ObjectNode(pd) : new PropertyNode(pd));
        parent.add(node);
    }
}

