/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.nodes;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.propertybrowser.PropertyBrowserModel;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditorMgr;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditorOwner;
import org.openbp.jaspira.propertybrowser.editor.PropertyValidator;
import org.openbp.jaspira.propertybrowser.nodes.AbstractNode;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;
import org.openbp.swing.components.treetable.JTreeTable;

public class PropertyNode
extends AbstractNode
implements PropertyEditorOwner {
    private PropertyDescriptor propertyDescriptor;
    private PropertyEditor propertyEditor;

    public PropertyNode(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"propertyDescriptor.name");
    }

    @Override
    public void reload() {
        super.reload();
        this.initPropertyEditor();
        if (this.propertyEditor != null) {
            this.propertyEditor.loadProperty();
        }
        if (this.propertyBrowser != null) {
            this.propertyBrowser.saveCurrentPosition();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyBrowserModel model;
                    if (PropertyNode.this.propertyBrowser != null && (model = (PropertyBrowserModel)((Object)PropertyNode.this.propertyBrowser.getModel())) != null) {
                        model.fireNodeChanged((TreeNode)((Object)PropertyNode.this));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (PropertyNode.this.propertyBrowser != null) {
                                    PropertyNode.this.propertyBrowser.restoreCurrentPosition();
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public boolean representsProperty(String propertyName) {
        return this.propertyDescriptor != null && this.propertyDescriptor.getName().equals(propertyName);
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        super.copyFrom(source, copyMode);
        PropertyNode src = (PropertyNode)source;
        this.propertyDescriptor = src.propertyDescriptor;
        PropertyEditor propertyEditor = this.propertyEditor = src.propertyEditor != null ? (PropertyEditor)src.propertyEditor.clone() : null;
        if (this.propertyEditor != null) {
            this.propertyEditor.setOwner(this);
        }
    }

    @Override
    public PropertyValidator getValidator() {
        ObjectNode on = this.getObjectNode();
        if (on != null) {
            return on.getValidator();
        }
        return null;
    }

    @Override
    public void handleKeyEvent(KeyEvent e) {
        if (this.propertyBrowser != null) {
            this.propertyBrowser.handleKeyEvent(e);
        }
    }

    public String getNodeText() {
        return this.propertyDescriptor != null ? this.propertyDescriptor.getDisplayName() : null;
    }

    @Override
    public Dimension getPreferredSize() {
        this.initPropertyEditor();
        if (this.propertyEditor == null) {
            return new Dimension(0, 0);
        }
        int componentHeight = 0;
        JComponent component = this.propertyEditor.getPropertyComponent();
        if (component != null) {
            componentHeight = component.getPreferredSize().height;
        }
        return new Dimension(0, componentHeight);
    }

    public Object getColumnValue(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.propertyDescriptor;
            }
            case 1: {
                this.initPropertyEditor();
                return this.propertyEditor;
            }
            case 2: {
                return JTreeTable.createDescriptionCellValue((String)this.propertyDescriptor.getDescription());
            }
        }
        return null;
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        if (this.propertyEditor != null) {
            this.propertyEditor.setObject(object);
        }
    }

    public boolean isReadOnly() {
        return this.propertyDescriptor.isReadOnly();
    }

    @Override
    public boolean shouldExpand() {
        return this.propertyDescriptor.isExpanded();
    }

    private void initPropertyEditor() {
        if (this.propertyEditor != null || this.propertyDescriptor == null) {
            return;
        }
        try {
            Class cls = this.propertyDescriptor.getEditorClass();
            if (cls == null) {
                if (this.propertyDescriptor.getEditorClassName() == null) {
                    return;
                }
                cls = PropertyEditorMgr.getInstance().findPropertyEditor(this.propertyDescriptor.getEditorClassName());
                if (cls == null) {
                    return;
                }
                this.propertyDescriptor.setEditorClass(cls);
            }
            PropertyEditor pe = (PropertyEditor)ReflectUtil.instantiate((Class)cls, PropertyEditor.class, (String)"property editor");
            pe.initialize(this.propertyDescriptor.getEditorParamString());
            pe.setPropertyName(this.propertyDescriptor.getName());
            pe.setReadonly(this.propertyDescriptor.isReadOnly());
            pe.setPropertyBrowser(this.propertyBrowser);
            if (this.propertyDescriptor.getValidatorClassName() != null) {
                cls = this.propertyDescriptor.getValidatorClass();
                if (cls == null && (cls = PropertyEditorMgr.getInstance().findPropertyValidator(this.propertyDescriptor.getValidatorClassName())) != null) {
                    this.propertyDescriptor.setValidatorClass(cls);
                }
                if (cls != null) {
                    PropertyValidator pv = (PropertyValidator)ReflectUtil.instantiate((Class)cls, PropertyValidator.class, (String)"property validator");
                    pe.setValidator(pv);
                }
            }
            if (this.object != null) {
                pe.setObject(this.object);
            }
            pe.setOwner(this);
            this.propertyEditor = pe;
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }
}

