/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.undo;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openbp.common.CollectionUtil;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.undo.Undoable;

public class UndoMgr {
    public static final int UNLIMITED_HISTORY_SIZE = -1;
    public static final int DEFAULT_HISTORY_SIZE = 25;
    public static final String TRANSITION_OPTION_NAME = "undo.history";
    private static String redoText;
    private static String undoText;
    private static String redoDescription;
    private static String undoDescription;
    private LinkedList undoStack = new LinkedList();
    private LinkedList redoStack = new LinkedList();
    private Transaction currentTransition;
    private int transitionHistorySize;

    public UndoMgr() {
        JaspiraAction undo;
        JaspiraAction redo;
        if (redoText == null && (redo = ActionMgr.getInstance().getAction("undo.redo")) != null) {
            redoText = redo.getDisplayName();
            redoDescription = redo.getDescription();
        }
        if (undoText == null && (undo = ActionMgr.getInstance().getAction("undo.undo")) != null) {
            undoText = undo.getDisplayName();
            undoDescription = undo.getDescription();
        }
        this.reloadHistorySize();
    }

    public Transaction startTransaction(String displayName) {
        if (this.currentTransition != null) {
            return null;
        }
        this.currentTransition = new Transaction(displayName);
        return this.currentTransition;
    }

    public void stopTransaction(Transaction trans) {
        if (trans == null) {
            return;
        }
        if (this.currentTransition != trans) {
            throw new RuntimeException("The transition: " + trans + "can't be stoped! It isn't active!");
        }
        this.undoStack.addFirst(this.currentTransition);
        if (this.transitionHistorySize != 0 && this.undoStack.size() > this.transitionHistorySize) {
            this.undoStack.removeLast();
        }
        this.currentTransition = null;
        this.redoStack.clear();
        this.updateActions();
    }

    public void registerUndoable(Undoable undo) {
        if (this.currentTransition == null) {
            this.startTransaction(undo.getDisplayName());
            this.currentTransition.addUndoable(undo);
            this.stopTransaction(this.currentTransition);
        } else {
            this.currentTransition.addUndoable(undo);
        }
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public void redo() {
        if (this.canRedo()) {
            Transaction trans = (Transaction)this.redoStack.removeFirst();
            this.undoStack.addFirst(trans);
            trans.redo();
        }
        this.updateActions();
    }

    public boolean canUndo() {
        return !this.undoStack.isEmpty();
    }

    public void undo() {
        if (this.canUndo()) {
            Transaction trans = (Transaction)this.undoStack.removeFirst();
            this.redoStack.addFirst(trans);
            trans.undo();
        }
        this.updateActions();
    }

    public void updateActions() {
        JaspiraAction redo;
        JaspiraAction undo = ActionMgr.getInstance().getAction("undo.undo");
        if (undo != null) {
            if (this.canUndo()) {
                String cmdName = ((Transaction)this.undoStack.getFirst()).getDisplayName();
                if (cmdName != null) {
                    String text = undoText + ": " + cmdName;
                    undo.setDisplayName(text);
                    undo.setDescription(text);
                } else {
                    undo.setDisplayName(undoText);
                    undo.setDescription(undoDescription);
                }
                undo.setEnabled(true);
            } else {
                undo.setDisplayName(undoText);
                undo.setEnabled(false);
            }
        }
        if ((redo = ActionMgr.getInstance().getAction("undo.redo")) != null) {
            if (this.canRedo()) {
                String cmdName = ((Transaction)this.redoStack.getFirst()).getDisplayName();
                if (cmdName != null) {
                    String text = redoText + ": " + cmdName;
                    redo.setDisplayName(text);
                    redo.setDescription(text);
                } else {
                    redo.setDisplayName(redoText);
                    redo.setDescription(redoDescription);
                }
                redo.setEnabled(true);
            } else {
                redo.setDisplayName(redoText);
                redo.setEnabled(false);
            }
        }
    }

    public void reloadHistorySize() {
        Option opt = OptionMgr.getInstance().getOption(TRANSITION_OPTION_NAME);
        this.transitionHistorySize = opt != null ? (Integer)opt.getValue() : 25;
        if (this.transitionHistorySize != -1) {
            int i;
            int del;
            if (this.redoStack.size() > this.transitionHistorySize) {
                del = this.redoStack.size() - this.transitionHistorySize;
                for (i = 1; i <= del; ++i) {
                    this.redoStack.removeLast();
                }
            }
            if (this.undoStack.size() > this.transitionHistorySize) {
                del = this.undoStack.size() - this.transitionHistorySize;
                for (i = 1; i <= del; ++i) {
                    this.undoStack.removeLast();
                }
            }
        }
    }

    public class Transaction {
        private String displayName;
        private LinkedList undoList;

        public Transaction(String displayName) {
            this.displayName = displayName;
            this.undoList = new LinkedList();
        }

        public void addUndoable(Undoable undo) {
            this.undoList.addFirst(undo);
        }

        public boolean isRedoable() {
            Iterator iter = this.undoList.iterator();
            while (iter.hasNext()) {
                if (((Undoable)iter.next()).isRedoable()) continue;
                return false;
            }
            return true;
        }

        public void undo() {
            Iterator iter = this.undoList.iterator();
            while (iter.hasNext()) {
                ((Undoable)iter.next()).undo();
            }
        }

        public void redo() {
            LinkedList redoList = new LinkedList();
            CollectionUtil.addReverseList((Collection)this.undoList, redoList);
            Iterator iter = redoList.iterator();
            while (iter.hasNext()) {
                ((Undoable)iter.next()).redo();
            }
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

