/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.awt;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class Color2StringConverter {
    public static final String SEPARATOR = ":";
    private static List predefinedColorList = new ArrayList();

    private Color2StringConverter() {
    }

    public static void addPredefinedColor(String name, Color color) {
        predefinedColorList.add(new PredefinedColor(name, color));
    }

    public static String color2Str(Color color) {
        if (color == null) {
            return null;
        }
        int n = predefinedColorList.size();
        for (int i = 0; i < n; ++i) {
            PredefinedColor pdc = (PredefinedColor)predefinedColorList.get(i);
            if (!pdc.color.equals(color)) continue;
            return pdc.name;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(color.getRed());
        sb.append(SEPARATOR);
        sb.append(color.getGreen());
        sb.append(SEPARATOR);
        sb.append(color.getBlue());
        if (color.getAlpha() != 255) {
            sb.append(SEPARATOR);
            sb.append(color.getAlpha());
        }
        return sb.toString();
    }

    public static Color str2Color(String s) {
        if (s == null) {
            return null;
        }
        int n = predefinedColorList.size();
        for (int i = 0; i < n; ++i) {
            PredefinedColor pdc = (PredefinedColor)predefinedColorList.get(i);
            if (!pdc.name.equals(s)) continue;
            return pdc.color;
        }
        StringTokenizer st = new StringTokenizer(s, SEPARATOR);
        int red = Color2StringConverter.getColorInt(st, 0);
        int green = Color2StringConverter.getColorInt(st, 0);
        int blue = Color2StringConverter.getColorInt(st, 0);
        int alpha = Color2StringConverter.getColorInt(st, 255);
        return new Color(red, green, blue, alpha);
    }

    private static int getColorInt(StringTokenizer st, int dflt) {
        if (st.hasMoreTokens()) {
            try {
                return Integer.valueOf(st.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dflt;
    }

    static {
        Color2StringConverter.addPredefinedColor("white", Color.white);
        Color2StringConverter.addPredefinedColor("lightGray", Color.lightGray);
        Color2StringConverter.addPredefinedColor("gray", Color.gray);
        Color2StringConverter.addPredefinedColor("darkGray", Color.darkGray);
        Color2StringConverter.addPredefinedColor("black", Color.black);
        Color2StringConverter.addPredefinedColor("red", Color.red);
        Color2StringConverter.addPredefinedColor("pink", Color.pink);
        Color2StringConverter.addPredefinedColor("orange", Color.orange);
        Color2StringConverter.addPredefinedColor("yellow", Color.yellow);
        Color2StringConverter.addPredefinedColor("green", Color.green);
        Color2StringConverter.addPredefinedColor("magenta", Color.magenta);
        Color2StringConverter.addPredefinedColor("cyan", Color.cyan);
        Color2StringConverter.addPredefinedColor("blue", Color.blue);
    }

    private static class PredefinedColor {
        public String name;
        public Color color;

        public PredefinedColor(String name, Color color) {
            this.name = name;
            this.color = color;
        }
    }
}

