/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.openbp.swing.Scalable;

public class SwingUtil {
    public static final String RESOURCE_COMMON = "common";
    private static boolean glassPaneVisible;
    private static Cursor glassPaneCursor;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 8;
    public static final int MIDDLE = 16;
    public static final int BOTTOM = 32;

    private SwingUtil() {
    }

    public static void startApplication(Window mainWindow, boolean provideExitHandler) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mainSize = mainWindow.getSize();
        if (mainSize.height > screenSize.height) {
            mainSize.height = screenSize.height;
        }
        if (mainSize.width > screenSize.width) {
            mainSize.width = screenSize.width;
        }
        mainWindow.setLocation((screenSize.width - mainSize.width) / 2, (screenSize.height - mainSize.height) / 2);
        if (provideExitHandler) {
            mainWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        mainWindow.setVisible(true);
    }

    public static void processPendingEvents() {
        if (Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent() != null) {
            Thread.yield();
        }
    }

    public static boolean focusComponent(Component comp) {
        if (comp == null) {
            return false;
        }
        if (comp.isFocusable() && !(comp instanceof JScrollPane)) {
            comp.requestFocus();
            return true;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!SwingUtil.focusComponent(comps[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static Point convertToGlassCoords(Point p, Component comp) {
        if (p == null) {
            p = new Point();
        }
        if (comp instanceof Scalable) {
            p = SwingUtil.applyScale(p, false, (Scalable)((Object)comp));
        }
        return SwingUtilities.convertPoint(comp, p, SwingUtil.getGlassPane(comp));
    }

    public static Point convertFromGlassCoords(Point p, Component comp) {
        if (p == null) {
            p = new Point();
        }
        p = SwingUtilities.convertPoint(SwingUtil.getGlassPane(comp), p, comp);
        if (comp instanceof Scalable) {
            p = SwingUtil.applyScale(p, true, (Scalable)((Object)comp));
        }
        return p;
    }

    public static Rectangle convertRectToGlassCoords(Rectangle r, Component comp) {
        return SwingUtilities.convertRectangle(comp, r, SwingUtil.getGlassPane(comp));
    }

    public static Rectangle convertBoundsToGlassCoords(Component comp) {
        return SwingUtilities.convertRectangle(comp, SwingUtilities.getLocalBounds(comp), SwingUtil.getGlassPane(comp));
    }

    public static Component getGlassPane(Component comp) {
        JRootPane root = SwingUtilities.getRootPane(comp);
        if (root == null) {
            throw new IllegalArgumentException("Component must be descendant of RootPaneContainer");
        }
        return root.getGlassPane();
    }

    public static Rectangle applyScale(Rectangle r, boolean scaleToDoc, Scalable view) {
        Rectangle result = new Rectangle();
        result.x = SwingUtil.applyScale(r.x, scaleToDoc, view);
        result.y = SwingUtil.applyScale(r.y, scaleToDoc, view);
        result.width = SwingUtil.applyScale(r.width, scaleToDoc, view);
        result.height = SwingUtil.applyScale(r.height, scaleToDoc, view);
        return result;
    }

    public static Point applyScale(Point p, boolean scaleToDoc, Scalable view) {
        Point result = new Point();
        result.x = SwingUtil.applyScale(p.x, scaleToDoc, view);
        result.y = SwingUtil.applyScale(p.y, scaleToDoc, view);
        return result;
    }

    public static int applyScale(int coordinate, boolean scaleToDoc, Scalable view) {
        double scaleFactor = view.getScaleFactor();
        coordinate = scaleToDoc ? (int)((double)coordinate / scaleFactor + 0.5) : (int)((double)coordinate * scaleFactor + 0.5);
        return coordinate;
    }

    public static void waitCursorOn(Component comp) {
        Component gp = SwingUtil.getGlassPane(comp);
        if (glassPaneCursor == null) {
            glassPaneVisible = gp.isVisible();
            glassPaneCursor = gp.getCursor();
        }
        gp.setVisible(true);
        gp.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void waitCursorOff(Component comp) {
        if (glassPaneCursor != null) {
            Component gp = SwingUtil.getGlassPane(comp);
            gp.setVisible(glassPaneVisible);
            gp.setCursor(glassPaneCursor);
            glassPaneVisible = false;
            glassPaneCursor = null;
        }
    }

    public static void forceMouseMove(Point pos) {
        try {
            Robot robot = new Robot();
            robot.setAutoDelay(0);
            robot.mouseMove(pos.x + 1, pos.y);
            robot.mouseMove(pos.x, pos.y);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public static boolean containsListener(EventListenerList listenerList, Class type, EventListener listener) {
        if (listenerList != null) {
            Object[] listeners = listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != type || listeners[i + 1] != listener) continue;
                return true;
            }
        }
        return false;
    }

    public static void drawMultilineString(Graphics g, String s, int alignment, Rectangle r, boolean print) {
        SwingUtil.drawMultilineString(g, null, s, alignment, r, print);
    }

    public static void computeMultilineStringBounds(FontMetrics fm, String s, int alignment, Rectangle r) {
        SwingUtil.drawMultilineString(null, fm, s, alignment, r, false);
    }

    private static void drawMultilineString(Graphics g, FontMetrics fm, String s, int alignment, Rectangle r, boolean print) {
        boolean lineCompleted;
        boolean wordCompleted;
        if (s == null) {
            return;
        }
        String word = "";
        String line = "";
        int maxWidth = 0;
        int height = 0;
        int n = s.length();
        if (fm == null) {
            fm = g.getFontMetrics();
        }
        if (r.height != 0 && (alignment & 0x30) != 0) {
            int totalHeight = 0;
            for (int i = 0; i < n; ++i) {
                char c = s.charAt(i);
                if (c == '\n') {
                    wordCompleted = true;
                    lineCompleted = true;
                } else {
                    word = c == '\t' ? word + "        " : word + c;
                    lineCompleted = i == n - 1;
                    boolean bl = wordCompleted = lineCompleted || Character.isSpaceChar(c);
                }
                if (wordCompleted) {
                    if (r.width > 0) {
                        if (fm.stringWidth(line + word) > r.width) {
                            totalHeight += fm.getHeight();
                            line = word;
                        } else {
                            line = line + word;
                        }
                    } else {
                        line = line + word;
                    }
                    word = "";
                }
                if (!lineCompleted) continue;
                totalHeight += fm.getHeight();
                line = "";
            }
            height = (alignment & 0x10) != 0 ? (r.height - totalHeight) / 2 : r.height - totalHeight;
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                wordCompleted = true;
                lineCompleted = true;
            } else {
                word = c == '\t' ? word + "        " : word + c;
                lineCompleted = i == n - 1;
                boolean bl = wordCompleted = lineCompleted || Character.isSpaceChar(c);
            }
            if (wordCompleted) {
                if (r.width > 0) {
                    if (fm.stringWidth(line + word) > r.width) {
                        if (fm.stringWidth(line) > maxWidth) {
                            maxWidth = fm.stringWidth(line);
                        }
                        height += fm.getHeight();
                        if (print) {
                            SwingUtil.drawString(g, line, alignment, new Rectangle(r.x, r.y + height - fm.getDescent(), r.width, 0));
                        }
                        line = word;
                    } else {
                        line = line + word;
                    }
                } else {
                    line = line + word;
                }
                word = "";
            }
            if (!lineCompleted) continue;
            if (fm.stringWidth(line) > maxWidth) {
                maxWidth = fm.stringWidth(line);
            }
            height += fm.getHeight();
            if (print) {
                SwingUtil.drawString(g, line, alignment, new Rectangle(r.x, r.y + height - fm.getDescent(), r.width, 0));
            }
            line = "";
        }
        if (r.width == 0 || !print) {
            r.width = maxWidth;
        }
        r.height = height;
    }

    public static void drawString(Graphics g, String s, int alignment, Rectangle r) {
        if (s == null) {
            return;
        }
        int x = r.x;
        if ((alignment & 2) != 0) {
            x += (r.width - g.getFontMetrics().stringWidth(s)) / 2;
        } else if ((alignment & 4) != 0) {
            x += r.width - g.getFontMetrics().stringWidth(s);
        }
        g.drawString(s, x, r.y);
    }

    public static void show(JDialog dlg) {
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public static void show(JFrame frame) {
        frame.setVisible(true);
    }

    public static void show(JWindow window) {
        window.setVisible(true);
    }

    public static RootPaneContainer getRootPaneContainer(Component c) {
        while (c != null) {
            if (c instanceof RootPaneContainer) {
                return (RootPaneContainer)((Object)c);
            }
            c = c.getParent();
        }
        return null;
    }

    public static JScrollPane getScrollPaneAncestor(Component c) {
        for (c = c.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JScrollPane)) continue;
            return (JScrollPane)c;
        }
        return null;
    }

    public static Dialog getDialog(Component c) {
        while (c != null) {
            if (c instanceof Dialog) {
                return (Dialog)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static void inflateRectangle(Rectangle r, int x, int y) {
        r.x -= x;
        r.y -= y;
        r.width += 2 * x;
        r.height += 2 * y;
    }
}

