/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class JConsole
extends JScrollPane {
    private JTextPane textPane = new JTextPane();
    private MutableAttributeSet standardAttributeSet;
    private transient InputStream oldIn;
    private transient PrintStream oldOut;
    private transient PrintStream oldErr;

    public JConsole() {
        this.textPane.setOpaque(false);
        this.setViewportView(this.textPane);
    }

    public void mapAll(boolean passThrough) {
        this.oldOut = this.mapSystemOut(passThrough);
        this.oldErr = this.mapSystemErr(passThrough);
        this.oldIn = this.mapSystemIn();
    }

    public void unmapAll() {
        if (this.oldOut != null) {
            System.setOut(this.oldOut);
            this.oldOut = null;
        }
        if (this.oldErr != null) {
            System.setErr(this.oldErr);
            this.oldErr = null;
        }
        if (this.oldIn != null) {
            System.setIn(this.oldIn);
            this.oldIn = null;
        }
    }

    public PrintStream mapSystemOut(boolean passThrough) {
        GUIMappedOutputStream mapper = this.createOutputStream(passThrough ? System.out : null);
        PrintStream oldOut = System.out;
        System.setOut(new PrintStream(mapper));
        return oldOut;
    }

    public PrintStream mapSystemErr(boolean passThrough) {
        int fontSize = this.getFont().getSize();
        GUIMappedOutputStream mapper = this.createOutputStream(passThrough ? System.err : null, Color.RED, new Font("Monospaced", 0, fontSize));
        PrintStream oldErr = System.err;
        System.setErr(new PrintStream(mapper));
        return oldErr;
    }

    public InputStream mapSystemIn() {
        GUIMappedInputStream mapper = this.createInputStream();
        InputStream oldIn = System.in;
        System.setIn(mapper);
        return oldIn;
    }

    public GUIMappedOutputStream createOutputStream() {
        return this.createOutputStream(null, null, null);
    }

    public GUIMappedOutputStream createOutputStream(OutputStream forwardTo) {
        return this.createOutputStream(forwardTo, null, null);
    }

    public GUIMappedOutputStream createOutputStream(OutputStream forwardTo, Color color) {
        return this.createOutputStream(forwardTo, color, null);
    }

    public GUIMappedOutputStream createOutputStream(OutputStream forwardTo, Color color, Font font) {
        GUIMappedOutputStream ret = new GUIMappedOutputStream(forwardTo);
        if (color != null) {
            ret.setColor(color);
        }
        if (font != null) {
            ret.setFont(font);
        }
        return ret;
    }

    public GUIMappedInputStream createInputStream() {
        return new GUIMappedInputStream();
    }

    public void flush() {
        this.textPane.setText("");
    }

    public void writeText(String text) {
        this.writeText(text, null);
    }

    public void writeText(String text, MutableAttributeSet attributeSet) {
        if (attributeSet == null) {
            if (this.standardAttributeSet == null) {
                Color color = Color.BLACK;
                Font font = this.getFont();
                this.standardAttributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(this.standardAttributeSet, color);
                StyleConstants.setFontFamily(this.standardAttributeSet, font.getFamily());
                StyleConstants.setFontSize(this.standardAttributeSet, font.getSize());
            }
            attributeSet = this.standardAttributeSet;
        }
        try {
            Document doc = this.textPane.getDocument();
            doc.insertString(doc.getLength(), text, attributeSet);
            this.textPane.setCaretPosition(doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    protected class GUIMappedInputStream
    extends InputStream
    implements KeyListener {
        private static final int BUFFERSIZE = 2048;
        private int[] buf = new int[2048];
        int inIndex = -1;
        int outIndex = -1;
        int available = 0;

        public GUIMappedInputStream() {
            JConsole.this.textPane.addKeyListener(this);
        }

        @Override
        public int available() {
            return this.available;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            while (this.available == 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.outIndex;
            if (this.outIndex == 2048) {
                this.outIndex = 0;
            }
            --this.available;
            return this.buf[this.outIndex];
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ++this.inIndex;
            ++this.available;
            if (this.inIndex == 2048) {
                this.inIndex = 0;
            }
            this.buf[this.inIndex] = e.getKeyCode();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    protected class GUIMappedOutputStream
    extends OutputStream {
        private OutputStream out;
        private Color color;
        private Font font;
        private MutableAttributeSet attributeSet;

        public GUIMappedOutputStream(OutputStream out) {
            this.out = out;
            this.color = Color.BLACK;
            this.font = JConsole.this.getFont();
            this.attributeSet = new SimpleAttributeSet();
        }

        @Override
        public void write(int b) throws IOException {
            StyleConstants.setForeground(this.attributeSet, this.color);
            StyleConstants.setFontFamily(this.attributeSet, this.font.getFamily());
            StyleConstants.setFontSize(this.attributeSet, this.font.getSize());
            JConsole.this.writeText(new Character((char)b).toString(), this.attributeSet);
            if (this.out != null) {
                this.out.write(b);
            }
        }

        public OutputStream getOut() {
            return this.out;
        }

        public void setOut(OutputStream out) {
            this.out = out;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }
    }
}

