/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openbp.common.MsgFormat;
import org.openbp.common.icon.MultiIcon;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.common.string.TextUtil;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.layout.VerticalFlowLayout;

public class JMsgBox
extends JDialog
implements ActionListener {
    public static final int TYPE_OK = 1;
    public static final int TYPE_CANCEL = 2;
    public static final int TYPE_OKCANCEL = 3;
    public static final int TYPE_YES = 4;
    public static final int TYPE_NO = 8;
    public static final int TYPE_YESNO = 12;
    public static final int TYPE_YESNOCANCEL = 14;
    public static final int TYPE_YES_FOR_ALL = 16;
    public static final int TYPE_NO_FOR_ALL = 32;
    public static final int TYPE_FOR_ALL = 48;
    public static final int TYPE_ABORT = 64;
    public static final int TYPE_RETRY = 128;
    public static final int TYPE_IGNORE = 256;
    public static final int TYPE_DO_NOT_SHOW_AGAIN = 512;
    public static final int ICON_INFO = 65536;
    public static final int ICON_WARNING = 131072;
    public static final int ICON_ERROR = 262144;
    public static final int ICON_FATAL = 524288;
    public static final int ICON_QUESTION = 0x100000;
    public static final int DEFAULT_OK = 0x200000;
    public static final int DEFAULT_CANCEL = 0x400000;
    public static final int DEFAULT_YES = 0x800000;
    public static final int DEFAULT_NO = 0x1000000;
    public static final int DEFAULT_ABORT = 0x2000000;
    public static final int DEFAULT_RETRY = 0x4000000;
    public static final int DEFAULT_IGNORE = 0x8000000;
    private static final int INVOKE_LATER = 0x40000000;
    public static final int TYPE_OKLATER = 0x40000001;
    private static final int PAD = 10;
    private static final Border OUTER_BORDER = BorderFactory.createEmptyBorder(20, 20, 10, 20);
    private static final Border ETCHED_BORDER = BorderFactory.createEtchedBorder();
    private static final Border INNER_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private static final Border BUTTON_BORDER = BorderFactory.createEmptyBorder(10, 10, 0, 10);
    private static final Border CHECKBOX_BORDER = BorderFactory.createEmptyBorder(10, 10, 0, 10);
    private static ResourceCollection defaultResourceCollection;
    private static String defaultTitle;
    public static DefaultOwnerProvider defaultOwnerProvider;
    private static Icon icon;
    private String msg;
    private int msgType;
    private int userChoice;
    private JButton defaultButton;
    private ArrayList buttons;
    private Map typeByButton;
    private Map buttonByType;
    private JCheckBox doNotShowAgainCheckBox;
    private ResourceCollection resourceCollection;
    private String resourcePrefix;
    private static final int[] allButtonConstants;
    private static final int[] allIconConstants;
    private static final int[] allDefaultButtonConstants;

    public JMsgBox(Component owner, String title, String msg, int msgType) {
        super(JMsgBox.getParentFrame(owner), title, true);
        this.msgType = msgType;
        this.msg = msg;
    }

    public int getUserChoice() {
        return this.userChoice;
    }

    public ResourceCollection getResource() {
        return this.resourceCollection;
    }

    public void setResource(ResourceCollection resourceCollection) {
        this.resourceCollection = resourceCollection;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public void setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
    }

    public void initDialog() {
        this.buttons = new ArrayList();
        this.typeByButton = new HashMap();
        this.buttonByType = new HashMap();
        this.parseMsgType();
        this.createUI(this.msg);
        this.setLocationRelativeTo(this.getOwner());
    }

    private void createUI(String msg) {
        String againMsg;
        JPanel content = new JPanel();
        content.setLayout(new VerticalFlowLayout());
        content.setBorder(OUTER_BORDER);
        JPanel standardPanel = new JPanel(new BorderLayout());
        standardPanel.setBorder(ETCHED_BORDER);
        if (icon != null) {
            JLabel iconPanel = new JLabel(icon);
            iconPanel.setBorder(INNER_BORDER);
            iconPanel.setVerticalAlignment(1);
            standardPanel.add("West", iconPanel);
        }
        List lines = TextUtil.breakIntoLines((String)msg, (boolean)true, (int)100);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lines.size(); ++i) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(lines.get(i));
        }
        msg = sb.toString();
        JTextArea messagePanel = new JTextArea(msg);
        messagePanel.setBorder(INNER_BORDER);
        messagePanel.setBackground(this.getContentPane().getBackground());
        Font font = messagePanel.getFont();
        int size = font.getSize() + 2;
        font = font.deriveFont((float)size);
        messagePanel.setFont(font);
        standardPanel.add("Center", messagePanel);
        messagePanel.setFocusable(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BUTTON_BORDER);
        buttonPanel.setLayout(new FlowLayout());
        for (int i = 0; i < this.buttons.size(); ++i) {
            buttonPanel.add((JButton)this.buttons.get(i));
        }
        content.add(standardPanel);
        content.add(buttonPanel);
        if ((this.msgType & 0x200) != 0 && (againMsg = defaultResourceCollection.getOptionalString("DoNotShowAgain")) != null) {
            this.doNotShowAgainCheckBox = new JCheckBox(againMsg);
            this.doNotShowAgainCheckBox.setBorder(CHECKBOX_BORDER);
            content.add(this.doNotShowAgainCheckBox);
        }
        this.getContentPane().add(content);
        this.pack();
        this.setResizable(false);
        if (this.defaultButton != null) {
            this.defaultButton.requestFocus();
        }
    }

    public static int show(Component owner, String msg, int msgType) {
        return JMsgBox.show(owner, null, msg, msgType);
    }

    public static int show(Component owner, String title, String msg, int msgType) {
        if (title == null && (title = defaultTitle) == null) {
            title = "Message";
        }
        final JMsgBox msgBox = new JMsgBox(owner, title, msg, msgType);
        msgBox.initDialog();
        if ((msgType & 0x40000000) != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtil.show(msgBox);
                }
            });
            return 1;
        }
        SwingUtil.show(msgBox);
        return msgBox.userChoice;
    }

    public static int show(Component owner, String msg, Object[] msgArgs, int msgType) {
        return JMsgBox.show(owner, null, msg, msgArgs, msgType);
    }

    public static int show(Component owner, String title, String msg, Object[] msgArgs, int msgType) {
        msg = MsgFormat.format((String)msg, (Object[])msgArgs);
        return JMsgBox.show(owner, title, msg, msgType);
    }

    public static int showFormat(Component owner, String msg, Object msgArg1, int msgType) {
        return JMsgBox.show(owner, null, msg, new Object[]{msgArg1}, msgType);
    }

    public static int showFormat(Component owner, String msg, Object msgArg1, Object msgArg2, int msgType) {
        return JMsgBox.show(owner, null, msg, new Object[]{msgArg1, msgArg2}, msgType);
    }

    public static int showFormat(Component owner, String msg, Object msgArg1, Object msgArg2, Object msgArg3, int msgType) {
        return JMsgBox.show(owner, null, msg, new Object[]{msgArg1, msgArg2, msgArg3}, msgType);
    }

    public static void setDefaultResourceCollection(ResourceCollection defaultResourceCollectionArg) {
        defaultResourceCollection = defaultResourceCollectionArg;
    }

    public static void setDefaultTitle(String defaultTitleArg) {
        defaultTitle = defaultTitleArg;
    }

    public static void setDefaultOwnerProvider(DefaultOwnerProvider defaultOwnerProviderArg) {
        defaultOwnerProvider = defaultOwnerProviderArg;
    }

    private void parseMsgType() {
        int i;
        ChoiceActionListener cancelListener = null;
        if (!this.hasButtonType()) {
            this.msgType = (this.msgType & 0x100000) != 0 ? (this.msgType |= 0xC) : (this.msgType |= 1);
        }
        for (i = 0; i < allButtonConstants.length; ++i) {
            String buttonType;
            HashMap mnemonicChars = new HashMap();
            if ((this.msgType & allButtonConstants[i]) == 0) continue;
            int buttonValue = allButtonConstants[i];
            switch (buttonValue) {
                case 1: {
                    buttonType = "ok";
                    break;
                }
                case 2: {
                    buttonType = "cancel";
                    break;
                }
                case 4: {
                    buttonType = "yes";
                    break;
                }
                case 8: {
                    buttonType = "no";
                    break;
                }
                case 16: {
                    buttonType = "yesforall";
                    break;
                }
                case 32: {
                    buttonType = "noforall";
                    break;
                }
                case 64: {
                    buttonType = "abort";
                    break;
                }
                case 128: {
                    buttonType = "retry";
                    break;
                }
                case 256: {
                    buttonType = "ignore";
                    break;
                }
                default: {
                    buttonType = "ok";
                }
            }
            String resourceGroup = "buttons." + buttonType;
            String buttonCaption = null;
            if (this.resourceCollection != null) {
                buttonCaption = this.resourceCollection.getOptionalString((this.resourcePrefix != null ? this.resourcePrefix : "") + resourceGroup + ".caption");
            }
            if (buttonCaption == null) {
                buttonCaption = defaultResourceCollection.getRequiredString(resourceGroup + ".caption");
            }
            char mnemonic = '~';
            int pos = buttonCaption.indexOf(95);
            if (pos != -1 && pos + 1 < buttonCaption.length()) {
                mnemonic = buttonCaption.charAt(pos + 1);
                mnemonicChars.put(new Character(mnemonic), null);
                buttonCaption = buttonCaption.substring(0, pos) + buttonCaption.substring(pos + 1);
            } else {
                for (int counter = 0; counter < buttonCaption.length(); ++counter) {
                    Character bufferChar = new Character(buttonCaption.charAt(counter));
                    if (mnemonicChars.containsKey(bufferChar)) continue;
                    mnemonic = bufferChar.charValue();
                    mnemonicChars.put(bufferChar, null);
                    break;
                }
            }
            JButton button = new JButton(buttonCaption);
            if (mnemonic != '~') {
                char activationChar;
                button.setMnemonic(mnemonic);
                ChoiceActionListener listener = new ChoiceActionListener(buttonValue);
                if (!(buttonValue != 1 && buttonValue != 2 && buttonValue != 64 || cancelListener != null && cancelListener.getChoice() != 1)) {
                    cancelListener = listener;
                }
                if (Character.isLowerCase(activationChar = mnemonic)) {
                    activationChar = Character.toUpperCase(activationChar);
                }
                ((JComponent)this.getContentPane()).registerKeyboardAction(listener, KeyStroke.getKeyStroke((int)activationChar, 0), 1);
            }
            button.addActionListener(this);
            this.buttons.add(button);
            this.typeByButton.put(button, new Integer(buttonValue));
            this.buttonByType.put(new Integer(buttonValue), button);
        }
        if (cancelListener != null) {
            ((JComponent)this.getContentPane()).registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 1);
        }
        if (!this.hasIconType()) {
            this.msgType = (this.msgType & 4) != 0 && (this.msgType & 8) != 0 ? (this.msgType |= 0x100000) : ((this.msgType & 0x40) != 0 && (this.msgType & 0x80) != 0 && (this.msgType & 0x100) != 0 ? (this.msgType |= 0x20000) : (this.msgType |= 0x10000));
        }
        for (i = 0; i < allIconConstants.length; ++i) {
            String iconName;
            if ((this.msgType & allIconConstants[i]) == 0) continue;
            int iconValue = allIconConstants[i];
            switch (iconValue) {
                case 65536: {
                    iconName = "information";
                    break;
                }
                case 131072: {
                    iconName = "warning";
                    break;
                }
                case 262144: {
                    iconName = "error";
                    break;
                }
                case 524288: {
                    iconName = "fatal";
                    break;
                }
                case 0x100000: {
                    iconName = "question";
                    break;
                }
                default: {
                    iconName = "information";
                }
            }
            String resourceName = "icons." + iconName;
            MultiIcon bufferIcon = null;
            if (this.resourceCollection != null) {
                bufferIcon = (MultiIcon)this.resourceCollection.getOptionalObject((this.resourcePrefix != null ? this.resourcePrefix : "") + resourceName);
            }
            if (bufferIcon == null) {
                bufferIcon = (MultiIcon)defaultResourceCollection.getOptionalObject(resourceName);
            }
            if (bufferIcon == null) {
                String name = iconName;
                if (name.equals("fatal")) {
                    name = "error";
                }
                icon = UIManager.getIcon("OptionPane." + name + "Icon");
                break;
            }
            icon = bufferIcon.getIcon(32);
            break;
        }
        for (i = 0; i < allDefaultButtonConstants.length; ++i) {
            if ((this.msgType & allDefaultButtonConstants[i]) == 0) continue;
            int defaultButtonValue = allDefaultButtonConstants[i];
            switch (defaultButtonValue) {
                case 0x200000: {
                    defaultButtonValue = 1;
                    break;
                }
                case 0x400000: {
                    defaultButtonValue = 2;
                    break;
                }
                case 0x800000: {
                    defaultButtonValue = 4;
                    break;
                }
                case 0x1000000: {
                    defaultButtonValue = 8;
                    break;
                }
                case 0x2000000: {
                    defaultButtonValue = 64;
                    break;
                }
                case 0x4000000: {
                    defaultButtonValue = 128;
                    break;
                }
                case 0x8000000: {
                    defaultButtonValue = 256;
                }
            }
            this.defaultButton = (JButton)this.buttonByType.get(new Integer(defaultButtonValue));
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Integer returnValue = (Integer)this.typeByButton.get(source);
        this.userChoice = returnValue;
        if (this.doNotShowAgainCheckBox != null && this.doNotShowAgainCheckBox.isSelected()) {
            this.userChoice |= 0x200;
        }
        this.dispose();
    }

    private boolean hasButtonType() {
        for (int i = 0; i < allButtonConstants.length; ++i) {
            if ((this.msgType & allButtonConstants[i]) == 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasIconType() {
        for (int i = 0; i < allIconConstants.length; ++i) {
            if ((this.msgType & allIconConstants[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public static JFrame getParentFrame(Component c) {
        while (c != null) {
            if (c instanceof JFrame) {
                return (JFrame)c;
            }
            c = c.getParent();
        }
        if (defaultOwnerProvider != null) {
            for (c = defaultOwnerProvider.getDefaultOwner(); c != null; c = c.getParent()) {
                if (!(c instanceof JFrame)) continue;
                return (JFrame)c;
            }
        }
        return null;
    }

    static {
        allButtonConstants = new int[]{1, 4, 8, 16, 32, 2, 64, 128, 256};
        allIconConstants = new int[]{65536, 131072, 262144, 524288, 0x100000};
        allDefaultButtonConstants = new int[]{0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000};
        defaultResourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("common", JMsgBox.class);
    }

    public static interface DefaultOwnerProvider {
        public Component getDefaultOwner();
    }

    private class ChoiceActionListener
    implements ActionListener {
        private int choice;

        ChoiceActionListener(int choice) {
            this.choice = choice;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMsgBox.this.userChoice = this.choice;
            if (JMsgBox.this.doNotShowAgainCheckBox != null && JMsgBox.this.doNotShowAgainCheckBox.isSelected()) {
                JMsgBox.this.userChoice |= 512;
            }
            JMsgBox.this.dispose();
        }

        public int getChoice() {
            return this.choice;
        }
    }
}

