/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openbp.swing.plaf.sky.ShadowBorder;
import org.openbp.swing.plaf.sky.SkyTheme;

public class JStandardDialog
extends JDialog {
    private JPanel mainPane;
    private JPanel btnPane;
    private JButton okBtn;
    private JButton cancelBtn;
    private boolean cancelled;

    public JStandardDialog() {
        this((Frame)null, true);
    }

    public JStandardDialog(Frame owner) {
        this(owner, true);
    }

    public JStandardDialog(boolean modal) {
        this((Frame)null, modal);
    }

    public JStandardDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize(true);
    }

    public JStandardDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.initialize(true);
    }

    public JStandardDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc, boolean showbuttons) {
        super(owner, title, modal, gc);
        this.initialize(showbuttons);
    }

    public JStandardDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc, boolean showbuttons) {
        super(owner, title, modal, gc);
        this.initialize(showbuttons);
    }

    private void initialize(boolean showbuttons) {
        this.mainPane = new JPanel(new BorderLayout());
        this.mainPane.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
        this.mainPane.setBorder(new ShadowBorder());
        this.getContentPane().add((Component)this.mainPane, "Center");
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStandardDialog.this.handleCancel();
            }
        };
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JStandardDialog.this.handleOk();
            }
        };
        if (showbuttons) {
            this.cancelBtn = new JButton("Cancel");
            this.cancelBtn.addActionListener(cancelListener);
            this.okBtn = new JButton("Ok");
            this.okBtn.addActionListener(okListener);
            this.btnPane = new JPanel();
            this.btnPane.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
            this.btnPane.setBorder(new ShadowBorder());
            this.btnPane.add(this.okBtn);
            this.btnPane.add(this.cancelBtn);
            this.getContentPane().add((Component)this.btnPane, "South");
            this.btnPane.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 1);
            this.btnPane.registerKeyboardAction(okListener, KeyStroke.getKeyStroke(10, 0), 1);
        }
        this.mainPane.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 1);
        this.mainPane.registerKeyboardAction(okListener, KeyStroke.getKeyStroke(10, 0), 1);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        this.setSize(size);
        if (this.getOwner() != null) {
            this.setLocationRelativeTo(this.getOwner());
        } else {
            this.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
        }
        super.setVisible(visible);
    }

    protected void handleOk() {
        this.setVisible(false);
        this.dispose();
    }

    protected void handleCancel() {
        this.cancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    public JPanel getMainPane() {
        return this.mainPane;
    }

    public JPanel getBtnPane() {
        return this.btnPane;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

