/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.tree;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtil {
    private TreeUtil() {
    }

    public static void expandTreeLevels(JTree tree, TreePath parent, boolean expand, int desiredLevel) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                if (desiredLevel > 0) {
                    TreeUtil.expandTreeLevels(tree, path, expand, desiredLevel - 1);
                    continue;
                }
                if (desiredLevel == 0) continue;
                TreeUtil.expandTreeLevels(tree, path, expand, -1);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void expandTreeLevels(JTree tree, boolean expand, int desiredLevel) {
        Object node;
        if (desiredLevel != 0 && (node = tree.getModel().getRoot()) instanceof TreeNode) {
            TreeNode root = (TreeNode)node;
            TreeUtil.expandTreeLevels(tree, new TreePath(root), expand, desiredLevel);
        }
    }
}

