/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class DefaultTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private EditorDelegate delegateObject = new EditorDelegate();

    @Override
    public Object getCellEditorValue() {
        return this.delegateObject.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegateObject.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegateObject.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegateObject.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegateObject.cancelCellEditing();
    }

    public void setValue(Object value) {
        this.delegateObject.setValue(value);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof String) {
            final JTextField textField = new JTextField();
            this.delegateObject = new EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    textField.setText(value != null ? value.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return textField.getText();
                }
            };
            textField.addActionListener(this.delegateObject);
            this.delegateObject.setValue(value);
            return textField;
        }
        if (value instanceof JComponent) {
            JComponent component = (JComponent)value;
            if (component instanceof JCheckBox && isSelected) {
                component.setForeground(UIManager.getColor("Table.selectionForeground"));
                component.setBackground(UIManager.getColor("Table.selectionBackground"));
            }
            return component;
        }
        return null;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        private Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean startCellEditing(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            DefaultTableCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            DefaultTableCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DefaultTableCellEditor.this.stopCellEditing();
        }
    }
}

