/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import javax.swing.tree.TreePath;
import org.openbp.swing.components.treetable.DefaultTreeTableNode;
import org.openbp.swing.components.treetable.SimpleTreeTableModel;

public class DefaultTreeTableModel
extends SimpleTreeTableModel {
    private int maxColumnCount;

    public DefaultTreeTableModel(DefaultTreeTableNode root) {
        super(root);
    }

    @Override
    public int getColumnCount() {
        if (this.maxColumnCount == 0) {
            this.maxColumnCount = super.getColumnCount();
        }
        return this.maxColumnCount;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object pathNode = path.getLastPathComponent();
        if (pathNode instanceof DefaultTreeTableNode) {
            DefaultTreeTableNode node = (DefaultTreeTableNode)pathNode;
            node.setColumnValue(0, newValue);
        }
    }

    public void addNode(DefaultTreeTableNode parent, DefaultTreeTableNode child) {
        if (parent == null) {
            parent = (DefaultTreeTableNode)child.getParent();
        }
        if (parent == null) {
            parent = (DefaultTreeTableNode)this.root;
        }
        parent.addChild(child);
        if (child.getColumnCount() > this.maxColumnCount) {
            this.maxColumnCount = child.getColumnCount();
        }
        this.fireNodeStructureChanged(parent);
    }

    public void removeNode(DefaultTreeTableNode node) {
        DefaultTreeTableNode parent = (DefaultTreeTableNode)node.getParent();
        parent.removeChild(node);
        this.fireNodeStructureChanged(parent);
    }
}

