/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable;

import java.awt.Dimension;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;
import org.openbp.common.util.iterator.EmptyEnumeration;
import org.openbp.swing.components.treetable.TreeTableNode;

public class DefaultTreeTableNode
implements TreeTableNode {
    public static final JLabel EMPTY_COLUMN = new JLabel(" ");
    protected List columnObjects;
    protected Dimension preferredSize;
    protected Vector children;
    protected DefaultTreeTableNode parent;
    private int lastHeight;

    @Override
    public String getNodeText() {
        if (this.columnObjects != null && this.columnObjects.get(0) != null) {
            return this.columnObjects.get(0).toString();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(0, 0);
            if (this.columnObjects != null) {
                for (int i = 0; i < this.columnObjects.size(); ++i) {
                    Object o = this.columnObjects.get(i);
                    if (!(o instanceof JComponent)) continue;
                    JComponent component = (JComponent)o;
                    Dimension componentSize = component.getPreferredSize();
                    if (!(this.preferredSize.getHeight() < componentSize.getHeight())) continue;
                    this.preferredSize = componentSize;
                }
            }
        }
        return this.preferredSize;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeTableNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node instanceof TreeTableNode) {
            TreeTableNode treeTableNode = (TreeTableNode)node;
            return this.children.indexOf(treeTableNode);
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Enumeration children() {
        if (this.children != null) {
            return this.children.elements();
        }
        return EmptyEnumeration.getInstance();
    }

    public void addChild(DefaultTreeTableNode child) {
        if (this.children == null) {
            this.children = new Vector();
        }
        child.setParent(this);
        this.children.add(child);
    }

    public boolean removeChild(DefaultTreeTableNode child) {
        return this.children.remove(child);
    }

    public void removeChildren() {
        this.children.clear();
    }

    public void insertChild(DefaultTreeTableNode child, int index) {
        if (this.children == null) {
            this.addChild(child);
            return;
        }
        child.setParent(this);
        this.children.add(index, child);
    }

    public void setParent(DefaultTreeTableNode parent) {
        this.parent = parent;
    }

    public void addColumn(Object columnValue) {
        if (this.columnObjects == null) {
            this.columnObjects = new Vector();
        }
        this.columnObjects.add(columnValue);
    }

    public boolean removeColumn(Object columnValue) {
        int objectPos = this.columnObjects.indexOf(columnValue);
        if (objectPos > 0) {
            this.columnObjects.set(objectPos, EMPTY_COLUMN);
            return true;
        }
        return false;
    }

    public void setColumnValue(int index, Object columnValue) {
        this.columnObjects.set(index, columnValue);
    }

    @Override
    public Object getColumnValue(int index) {
        try {
            if (index == 0) {
                return this;
            }
            if (this.columnObjects == null) {
                return null;
            }
            return this.columnObjects.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getColumnCount() {
        return this.columnObjects == null ? 0 : this.columnObjects.size();
    }

    @Override
    public int getLastHeight() {
        return this.lastHeight;
    }

    @Override
    public void setLastHeight(int lastHeight) {
        this.lastHeight = lastHeight;
    }
}

