/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.treetable.resize;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.components.treetable.SimpleTreeTableModel;
import org.openbp.swing.components.treetable.TreeTableNode;

public class ColumnSizeConstraint {
    protected int absoluteMinSize = 40;
    protected static final int MAX = 0;
    protected static final int MIN = 1;
    protected static final int PREFERRED = 2;
    protected int[][] columnSizes;
    protected int[] minSizeOfColumns = new int[0];
    protected int treeColumnMaxWidth = 0;
    private List maxColumnSize = new ArrayList();

    private void init(JTreeTable treetable) {
        int columnCount = treetable.getColumnCount();
        if (this.columnSizes == null || columnCount != this.columnSizes[0].length) {
            this.columnSizes = new int[3][columnCount];
        }
        if (this.minSizeOfColumns.length != columnCount) {
            this.minSizeOfColumns = new int[columnCount];
            for (int i = 0; i < this.minSizeOfColumns.length; ++i) {
                this.minSizeOfColumns[i] = this.absoluteMinSize;
            }
        }
    }

    public void calculateColumnSizes(JTreeTable treetable) {
        this.init(treetable);
        int columnCount = treetable.getColumnCount();
        int tWidth = treetable.getWidth();
        int tMax = tWidth - (columnCount - 1) * this.absoluteMinSize;
        for (int i = 0; i < columnCount; ++i) {
            this.columnSizes[0][i] = tMax;
            this.columnSizes[2][i] = this.determineMaxColumnWidth(treetable, i);
            this.columnSizes[1][i] = this.absoluteMinSize;
        }
    }

    public void adjustPreferredToWidth(JTreeTable treetable) {
        int columnCount = treetable.getColumnCount();
        int tWidth = treetable.getWidth();
        int preferred = 0;
        for (int i = 0; i < columnCount; ++i) {
            preferred += this.columnSizes[2][i];
        }
        double div = (double)tWidth / (double)preferred;
        for (int i = 0; i < columnCount; ++i) {
            this.columnSizes[2][i] = (int)((double)this.columnSizes[2][i] * div);
        }
    }

    public void adjustMaximalWidthOfColumn(JTreeTable treetable) {
        int columnCount = treetable.getColumnCount();
        for (int i = 0; i < this.maxColumnSize.size(); ++i) {
            int maxColumnWidth;
            MaxColumnWidth mcw = (MaxColumnWidth)this.maxColumnSize.get(i);
            int columnWidth = this.getPreferredWidthOfColumn(mcw.column);
            if (columnWidth <= (maxColumnWidth = (int)((double)treetable.getWidth() * mcw.max))) continue;
            this.setColumnWidth(2, i, maxColumnWidth);
            int delta = (columnWidth - maxColumnWidth) / (columnCount - 1);
            for (int j = 0; j < columnCount; ++j) {
                if (i == j) continue;
                this.setColumnWidth(2, j, this.getPreferredWidthOfColumn(j) + delta);
            }
        }
    }

    public boolean isRecalculateNeeded(JTreeTable treetable) {
        int width = treetable.getWidth();
        int preferredWidth = 0;
        for (int i = 0; i < treetable.getColumnCount(); ++i) {
            preferredWidth += treetable.getColumnModel().getColumn(i).getPreferredWidth();
        }
        return width != preferredWidth;
    }

    public int getMinWidthOfColumn(int column) {
        return this.columnSizes[1][column];
    }

    public int getMaxWidthOfColumn(int column) {
        return this.columnSizes[0][column];
    }

    public int getPreferredWidthOfColumn(int column) {
        return this.columnSizes[2][column];
    }

    protected void setColumnWidth(int type, int column, int width) {
        this.columnSizes[type][column] = width;
    }

    public void setAboluteMinimun(int minSize) {
        this.absoluteMinSize = minSize;
        for (int i = 0; i < this.minSizeOfColumns.length; ++i) {
            if (this.minSizeOfColumns[i] >= minSize) continue;
            this.minSizeOfColumns[i] = minSize;
        }
    }

    public int getAbsoluteMinimum() {
        return this.absoluteMinSize;
    }

    public void setMinimumOfColumn(int columnWidth, int column, JTreeTable treetable) {
        this.init(treetable);
        if (columnWidth > this.absoluteMinSize) {
            this.minSizeOfColumns[column] = columnWidth;
        }
    }

    public int determineMaxColumnWidth(JTreeTable treetable, int column) {
        Font font = treetable.getFont();
        Graphics graphics = treetable.getGraphics();
        if (graphics == null) {
            return 0;
        }
        FontMetrics fm = graphics.getFontMetrics(font);
        int level = treetable.getTree().isRootVisible() ? 1 : 0;
        TreeTableNode node = (TreeTableNode)((SimpleTreeTableModel)treetable.getModel()).getRoot();
        int columnMaxWidth = this.determineMaxColumnWidth(node, treetable.getTree().isRootVisible(), column, level, 0, fm);
        if (column == 0) {
            this.treeColumnMaxWidth = columnMaxWidth;
        }
        return columnMaxWidth;
    }

    public int determineMaxTreeColumnWidth(JTreeTable treetable) {
        return this.determineMaxColumnWidth(treetable, 0);
    }

    private int determineMaxColumnWidth(TreeTableNode node, boolean isRootVisible, int column, int level, int max, FontMetrics fm) {
        int w;
        if (node == null) {
            return max;
        }
        if ((isRootVisible && node.getParent() == null || node.getParent() != null) && (w = this.getWidthOfNode(node, column, fm, level)) > max) {
            max = w;
        }
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeTableNode child = (TreeTableNode)node.getChildAt(i);
            max = this.determineMaxColumnWidth(child, isRootVisible, column, level + 1, max, fm);
        }
        return max;
    }

    private int getWidthOfNode(TreeTableNode node, int column, FontMetrics fm, int level) {
        Object colValue;
        Object object = colValue = column == 0 ? node.getNodeText() : node.getColumnValue(column);
        if (colValue instanceof JComponent) {
            return ((JComponent)colValue).getWidth();
        }
        if (colValue == null) {
            return 0;
        }
        String str = "";
        if (colValue instanceof String) {
            str = (String)colValue;
        } else if (level > 0) {
            str = colValue.toString();
        }
        int w = SwingUtilities.computeStringWidth(fm, str);
        if (column == 0) {
            w += level * 20;
        }
        return w += 5;
    }

    public void addMaxSizeForColumn(int column, double maxValue) {
        this.maxColumnSize.add(new MaxColumnWidth(column, maxValue));
    }

    class MaxColumnWidth {
        int column;
        double max;

        public MaxColumnWidth(int column, double max) {
            this.column = column;
            this.max = max;
        }
    }
}

