/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.wizard;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public class EdgeBorder
implements Border,
SwingConstants {
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    protected int edgePosition = 1;
    protected int style = 2;

    public EdgeBorder() {
        this(1);
    }

    public EdgeBorder(int edgePosition) {
        this.edgePosition = edgePosition;
    }

    @Override
    public Insets getBorderInsets(Component comp) {
        switch (this.edgePosition) {
            case 5: {
                return new Insets(0, 0, 2, 0);
            }
            case 3: {
                return new Insets(0, 2, 0, 0);
            }
            case 7: {
                return new Insets(0, 0, 0, 2);
            }
        }
        return new Insets(2, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
        if (this.style == 1) {
            g.setColor(component.getBackground().brighter());
        } else {
            g.setColor(component.getBackground().darker());
        }
        switch (this.edgePosition) {
            case 5: {
                g.drawLine(x, y + h - 2, w, y + h - 2);
                break;
            }
            case 3: {
                g.drawLine(x + w - 2, y, x + w - 2, y + h);
                break;
            }
            case 7: {
                g.drawLine(x + 1, y, x + 1, y + h);
                break;
            }
            default: {
                g.drawLine(x, y, x + w, y);
            }
        }
        if (this.style == 1) {
            g.setColor(component.getBackground().darker());
        } else {
            g.setColor(component.getBackground().brighter());
        }
        switch (this.edgePosition) {
            case 5: {
                g.drawLine(x, y + h - 1, w, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x + w - 1, y, x + w - 1, y + h);
                break;
            }
            case 7: {
                g.drawLine(x + 1, y, x + 1, y + h);
                break;
            }
            default: {
                g.drawLine(x, y + 1, x + w, y + 1);
            }
        }
    }
}

