/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components.wizard;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionUtil;
import org.openbp.swing.components.wizard.EdgeBorder;
import org.openbp.swing.components.wizard.Wizard;

public class WizardNavigator
extends JPanel
implements ActionListener {
    private Wizard wizard;
    private ResourceCollection wizardResourceCollection;
    JButton back;
    JButton next;
    JButton finish;
    JButton cancel;
    JButton close;
    JButton help;

    public WizardNavigator(Wizard wizard, ResourceCollection wizardResourceCollection) {
        this.wizard = wizard;
        this.wizardResourceCollection = wizardResourceCollection;
        this.setOpaque(true);
        this.setLayout(new FlowLayout(2, 10, 10));
        this.setBorder(new EdgeBorder(1));
        this.back = this.createButton("Back");
        this.back.setMargin(new Insets(1, 5, 1, 10));
        this.back.addActionListener(this);
        this.add(this.back);
        this.next = this.createButton("Next");
        this.next.setHorizontalTextPosition(2);
        this.next.setMargin(new Insets(1, 1, 1, 1));
        this.next.addActionListener(this);
        this.add(this.next);
        this.finish = this.createButton("Finish");
        this.finish.addActionListener(this);
        this.add(this.finish);
        this.cancel = this.createButton("Cancel");
        this.cancel.addActionListener(this);
        this.add(this.cancel);
        this.close = this.createButton("Close");
        this.close.addActionListener(this);
        this.add(this.close);
        this.help = new JButton("Help");
        this.help.setMnemonic('H');
        this.add(this.help);
    }

    public void setShowHelp(boolean showHelp) {
        this.help.setVisible(showHelp);
    }

    private JButton createButton(String name) {
        URL url;
        String lowName = name.toLowerCase();
        String title = null;
        ImageIcon icon = null;
        char mnemonic = '\u0000';
        int x = 75;
        int y = 26;
        if (this.wizardResourceCollection != null) {
            title = this.wizardResourceCollection.getOptionalString(lowName + ".name", name);
            Object o = this.wizardResourceCollection.getOptionalObject(lowName + ".icon");
            if (o != null && o instanceof ImageIcon) {
                icon = (ImageIcon)o;
            }
            mnemonic = ResourceCollectionUtil.getOptionalChar((ResourceCollection)this.wizardResourceCollection, (String)(lowName + ".mnemonic"), (char)title.charAt(0));
            x = ResourceCollectionUtil.getOptionalInt((ResourceCollection)this.wizardResourceCollection, (String)(lowName + ".xsize"), (int)x);
            y = ResourceCollectionUtil.getOptionalInt((ResourceCollection)this.wizardResourceCollection, (String)(lowName + ".ysize"), (int)y);
        }
        if (title == null) {
            title = name;
        }
        if (icon == null && (url = this.getClass().getClassLoader().getResource("com/openbp/swing/components/wizard/" + name + ".gif")) != null) {
            icon = new ImageIcon(url);
        }
        if (mnemonic == '\u0000') {
            mnemonic = title.charAt(0);
        }
        JButton button = new JButton(title, icon);
        button.setMnemonic(mnemonic);
        button.setPreferredSize(new Dimension(x, y));
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.back) {
            this.wizard.displayBack();
        } else if (source == this.next) {
            this.wizard.displayNext();
        } else if (source == this.finish) {
            this.wizard.finish();
        } else if (source == this.cancel) {
            this.wizard.cancel();
        } else if (source == this.close) {
            this.wizard.close();
        }
    }

    public void updateNavigator() {
        boolean canBack = this.wizard.hasBackward() && this.wizard.canMoveBackward();
        this.back.setEnabled(canBack);
        boolean canForward = this.wizard.hasForward() && this.wizard.canMoveForward();
        this.next.setEnabled(canForward);
        String resultPageName = this.wizard.getResultPageName();
        if (resultPageName != null && resultPageName.equals(this.wizard.getManager().getCurrent())) {
            this.finish.setEnabled(false);
            this.cancel.setVisible(false);
            this.close.setVisible(true);
        } else {
            boolean canFinish = this.wizard.canFinish();
            this.finish.setEnabled(canFinish);
            this.cancel.setVisible(true);
            this.close.setVisible(false);
        }
        boolean canCancel = this.wizard.canCancel();
        this.cancel.setEnabled(canCancel);
        this.close.setEnabled(canCancel);
        this.paintAll(this.getGraphics());
    }
}

