/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.draw;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RadialGradientPaintContext
implements PaintContext {
    protected Point2D center;
    protected Point2D radius;
    protected Color centerColor;
    protected Color backgroundColor;

    public RadialGradientPaintContext(Point2D center, Color centerColor, Point2D radius, Color backgroundColor) {
        this.center = center;
        this.centerColor = centerColor;
        this.radius = radius;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                double rad;
                double distance = this.center.distance(x + i, y + j);
                double ratio = distance / (rad = this.radius.distance(0.0, 0.0));
                if (ratio > 1.0) {
                    ratio = 1.0;
                }
                int base = (j * w + i) * 4;
                data[base + 0] = (int)((double)this.centerColor.getRed() + ratio * (double)(this.backgroundColor.getRed() - this.centerColor.getRed()));
                data[base + 1] = (int)((double)this.centerColor.getGreen() + ratio * (double)(this.backgroundColor.getGreen() - this.centerColor.getGreen()));
                data[base + 2] = (int)((double)this.centerColor.getBlue() + ratio * (double)(this.backgroundColor.getBlue() - this.centerColor.getBlue()));
                data[base + 3] = (int)((double)this.centerColor.getAlpha() + ratio * (double)(this.backgroundColor.getAlpha() - this.centerColor.getAlpha()));
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

