/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class DeckLayout
implements LayoutManager2,
Serializable {
    private Hashtable comps = new Hashtable();
    private boolean wrap = false;

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    @Override
    public void addLayoutComponent(Component c, Object constraints) {
        if (!(constraints instanceof String) && constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
        }
        this.addLayoutComponent((String)constraints, c);
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
        if (name == null) {
            throw new IllegalArgumentException("Component must have a name");
        }
        if (this.comps.size() > 0) {
            this.setActive(c, false);
        }
        this.comps.put(name, c);
    }

    @Override
    public void removeLayoutComponent(Component c) {
        Enumeration en = this.comps.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (this.comps.get(key) != c) continue;
            this.comps.remove(key);
            return;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getMinimumSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w, insets.top + insets.bottom + h);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component c = parent.getComponent(i);
            if (!c.isVisible()) continue;
            c.setBounds(insets.left, insets.top, parent.getSize().width - (insets.left + insets.right), parent.getSize().height - (insets.top + insets.bottom));
        }
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private void checkLayout(Container parent) {
        if (parent.getLayout() != this) {
            throw new IllegalArgumentException("wrong parent for CardLayout");
        }
    }

    private void setActive(Component c, boolean enabled) {
        c.setVisible(enabled);
        c.setEnabled(enabled);
        if (c instanceof Container) {
            Container container = (Container)c;
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.setActive(container.getComponent(i), enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void first(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            int ncomponents = parent.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                this.setActive(c, false);
                c = parent.getComponent(0);
                this.setActive(c, true);
                parent.validate();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int next(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            int ncomponents = parent.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                if (i + 1 >= ncomponents && !this.wrap) {
                    return i;
                }
                int index = i + 1 < ncomponents ? i + 1 : 0;
                this.setActive(c, false);
                c = parent.getComponent(index);
                this.setActive(c, true);
                parent.validate();
                return index;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int previous(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            int ncomponents = parent.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                if (i <= 0 && !this.wrap) {
                    return i;
                }
                this.setActive(c, false);
                int index = i > 0 ? i - 1 : ncomponents - 1;
                c = parent.getComponent(index);
                this.setActive(c, true);
                parent.validate();
                return index;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void last(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            int ncomponents = parent.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                this.setActive(c, false);
                c = parent.getComponent(ncomponents - 1);
                this.setActive(c, true);
                parent.validate();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Container parent, String name) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            Component next = (Component)this.comps.get(name);
            if (next != null && !next.isVisible()) {
                int ncomponents = parent.getComponentCount();
                for (int i = 0; i < ncomponents; ++i) {
                    Component c = parent.getComponent(i);
                    if (!c.isVisible()) continue;
                    this.setActive(c, false);
                    break;
                }
                this.setActive(next, true);
                parent.validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Container parent, int index) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.checkLayout(parent);
            if (index < 0 || index > parent.getComponentCount() - 1) {
                return;
            }
            int ncomponents = parent.getComponentCount();
            for (int i = 0; i < ncomponents; ++i) {
                Component c = parent.getComponent(i);
                if (!c.isVisible()) continue;
                this.setActive(c, false);
                c = parent.getComponent(index);
                this.setActive(c, true);
                parent.validate();
                return;
            }
        }
    }

    public Component getComponentByName(String name) {
        return (Component)this.comps.get(name);
    }
}

