/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class UnitLayout
implements LayoutManager2,
Serializable {
    public static final int TOP = 1;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 3;
    protected int xpos = 2;
    protected int ypos = 2;
    private boolean haveComponent = false;

    public UnitLayout() {
        this(2, 2);
    }

    public UnitLayout(int xpos, int ypos) {
        this.xpos = xpos;
        this.ypos = ypos;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (this.haveComponent) {
            throw new IllegalArgumentException("Only one child component permitted");
        }
        this.haveComponent = true;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, name);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.haveComponent = false;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension size = this.haveComponent ? new Dimension(container.getComponent(0).getMinimumSize()) : new Dimension(10, 10);
        Insets insets = container.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        if (!this.haveComponent) {
            return;
        }
        Component component = container.getComponent(0);
        Dimension size = container.getSize();
        Insets insets = container.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = component.getPreferredSize().width;
        int h = component.getPreferredSize().height;
        if (this.xpos == 2) {
            x += (size.width - w) / 2;
        }
        if (this.xpos == 3) {
            x += size.width - w;
        }
        if (this.ypos == 2) {
            y += (size.height - h) / 2;
        }
        if (this.ypos == 3) {
            y += size.height - h;
        }
        component.setBounds(x, y, w, h);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

