/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.layout.dock;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class DockLayout
implements LayoutManager2,
Serializable {
    public static final String STR_CENTER = "Center";
    public static final String STR_NORTH = "North";
    public static final String STR_SOUTH = "South";
    public static final String STR_EAST = "East";
    public static final String STR_WEST = "West";
    public static final String STR_TOP = "Top";
    public static final String STR_BOTTOM = "Bottom";
    public static final String STR_RIGHT = "Right";
    public static final String STR_LEFT = "Left";
    private boolean horizontalOrder = true;
    private int horizontalGap = 2;
    private int verticalGap = 2;
    private static final int INDEX_CENTER = 0;
    private static final int INDEX_NORTH = 1;
    private static final int INDEX_SOUTH = 2;
    private static final int INDEX_EAST = 3;
    private static final int INDEX_WEST = 4;
    private static final int NINDICES = 5;
    private Component[] components = new Component[5];
    private int top;
    private int bottom;
    private int left;
    private int right;

    public DockLayout() {
        this(0, 0);
    }

    public DockLayout(int horizontalGap, int verticalGap) {
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
    }

    public boolean getHorizontalOrder() {
        return this.horizontalOrder;
    }

    public void setHorizontalOrder(boolean horizontalOrder) {
        this.horizontalOrder = horizontalOrder;
    }

    public int getHgap() {
        return this.horizontalGap;
    }

    public void setHgap(int horizontalGap) {
        this.horizontalGap = horizontalGap;
    }

    public int getVgap() {
        return this.verticalGap;
    }

    public void setVgap(int verticalGap) {
        this.verticalGap = verticalGap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String constraint, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int index = this.stringConstraintToIndex(constraint);
            if (index < 0) {
                throw new IllegalArgumentException("Unknown constraint '" + constraint + "' for DockLayout");
            }
            this.components[index] = comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < 5; ++i) {
                if (this.components[i] != comp) continue;
                this.components[i] = null;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            this.top = insets.top;
            this.bottom = target.getHeight() - insets.bottom;
            this.left = insets.left;
            this.right = target.getWidth() - insets.right;
            if (this.horizontalOrder) {
                this.layoutNorthSouth();
                this.layoutEastWest();
            } else {
                this.layoutEastWest();
                this.layoutNorthSouth();
            }
            Component c = null;
            c = this.getComponent(0);
            if (c != null) {
                c.setBounds(this.left, this.top, this.right - this.left, this.bottom - this.top);
            }
        }
    }

    private void layoutNorthSouth() {
        Dimension d;
        Component c = null;
        c = this.getComponent(1);
        if (c != null) {
            c.setSize(this.right - this.left, c.getHeight());
            d = c.getPreferredSize();
            c.setBounds(this.left, this.top, this.right - this.left, d.height);
            this.top += d.height + this.verticalGap;
        }
        if ((c = this.getComponent(2)) != null) {
            c.setSize(this.right - this.left, c.getHeight());
            d = c.getPreferredSize();
            c.setBounds(this.left, this.bottom - d.height, this.right - this.left, d.height);
            this.bottom -= d.height + this.verticalGap;
        }
    }

    private void layoutEastWest() {
        Dimension d;
        Component c = null;
        c = this.getComponent(3);
        if (c != null) {
            c.setSize(c.getWidth(), this.bottom - this.top);
            d = c.getPreferredSize();
            c.setBounds(this.right - d.width, this.top, d.width, this.bottom - this.top);
            this.right -= d.width + this.horizontalGap;
        }
        if ((c = this.getComponent(4)) != null) {
            c.setSize(c.getWidth(), this.bottom - this.top);
            d = c.getPreferredSize();
            c.setBounds(this.left, this.top, d.width, this.bottom - this.top);
            this.left += d.width + this.horizontalGap;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.determineLayoutSize(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.determineLayoutSize(target, false);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension determineLayoutSize(Container target, boolean preferedSize) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            Component c = null;
            c = this.getComponent(3);
            if (c != null) {
                d = this.getSize(c, preferedSize);
                dim.width += d.width + this.horizontalGap;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getComponent(4)) != null) {
                d = this.getSize(c, preferedSize);
                dim.width += d.width + this.horizontalGap;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getComponent(0)) != null) {
                d = this.getSize(c, preferedSize);
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getComponent(1)) != null) {
                d = this.getSize(c, preferedSize);
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.verticalGap;
            }
            if ((c = this.getComponent(2)) != null) {
                d = this.getSize(c, preferedSize);
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.verticalGap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    private Dimension getSize(Component c, boolean preferedSize) {
        return preferedSize ? c.getPreferredSize() : c.getMinimumSize();
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    protected Component getComponent(int index) {
        Component result = this.components[index];
        if (result != null && !result.isVisible()) {
            result = null;
        }
        return result;
    }

    protected int stringConstraintToIndex(String constraint) {
        int index = -1;
        if (constraint == null || constraint.equalsIgnoreCase(STR_CENTER)) {
            index = 0;
        } else if (constraint.equalsIgnoreCase(STR_NORTH) || constraint.equalsIgnoreCase(STR_TOP)) {
            index = 1;
        } else if (constraint.equalsIgnoreCase(STR_SOUTH) || constraint.equalsIgnoreCase(STR_BOTTOM)) {
            index = 2;
        } else if (constraint.equalsIgnoreCase(STR_EAST) || constraint.equalsIgnoreCase(STR_RIGHT)) {
            index = 3;
        } else if (constraint.equalsIgnoreCase(STR_WEST) || constraint.equalsIgnoreCase(STR_LEFT)) {
            index = 4;
        }
        return index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[");
        sb.append("order=");
        sb.append(this.horizontalOrder ? "horizontal" : "vertical");
        sb.append(",horizontalGap=");
        sb.append(this.horizontalGap);
        sb.append(",verticalGap=");
        sb.append(this.verticalGap);
        sb.append("]");
        return sb.toString();
    }
}

