/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.layout.splitter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.openbp.swing.components.DragGlassPane;
import org.openbp.swing.layout.splitter.SplitterLayout;
import org.openbp.swing.layout.splitter.SplitterSpace;

public class SplitterBar
extends JPanel {
    private static final Cursor VERT_CURSOR = new Cursor(8);
    private static final Cursor HORIZ_CURSOR = new Cursor(11);
    private static final Cursor DEF_CURSOR = new Cursor(0);
    private int orientation = 0;
    private boolean liveLayout = false;
    private boolean mouseInside = false;
    private static Point dragStartPos;
    public static final Color FOCUSCOLOR;
    public static final Color ENABLED_BORDERCOLOR;

    public SplitterBar() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                SplitterBar.this.mouseDrag(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SplitterBar.this.mouseEnter(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SplitterBar.this.mouseExit(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SplitterBar.this.mouseRelease(e);
            }
        });
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public boolean isLiveLayout() {
        return this.liveLayout;
    }

    public void setLiveLayout(boolean liveLayout) {
        this.liveLayout = liveLayout;
    }

    void mouseDrag(MouseEvent e) {
        Point delta;
        SplitterLayout layout = this.getSplitterLayout();
        if (layout == null) {
            return;
        }
        int localX = e.getX();
        int localY = e.getY();
        int x = localX + this.getX();
        int y = localY + this.getY();
        if (dragStartPos == null) {
            dragStartPos = new Point(x, y);
            delta = new Point(0, 0);
            this.repaint();
            if (!this.liveLayout) {
                DragGlassPane.getInstance().activate(this);
            }
        } else {
            delta = new Point(x - SplitterBar.dragStartPos.x, y - SplitterBar.dragStartPos.y);
            boolean handleMovement = false;
            if (this.orientation == 0) {
                if (delta.y > 0) {
                    if (localY >= 0) {
                        handleMovement = true;
                    }
                } else if (localY <= this.getHeight()) {
                    handleMovement = true;
                }
                delta.x = 0;
            } else {
                if (delta.x > 0) {
                    if (localX >= 0) {
                        handleMovement = true;
                    }
                } else if (localX <= this.getWidth()) {
                    handleMovement = true;
                }
                delta.y = 0;
            }
            if (handleMovement) {
                layout.processSplitterDrag(this, delta, this.liveLayout);
            }
            if (this.liveLayout || !handleMovement) {
                SplitterBar.dragStartPos.x = x;
                SplitterBar.dragStartPos.y = y;
            }
        }
        if (!this.liveLayout) {
            DragGlassPane gp = DragGlassPane.getInstance();
            Point barLoc = SwingUtilities.convertPoint(this, delta, gp);
            Rectangle targetRect = new Rectangle(barLoc.x, barLoc.y, this.getWidth(), this.getHeight());
            gp.drawRectangle(targetRect, true);
        }
    }

    void mouseRelease(MouseEvent e) {
        SplitterLayout layout = this.getSplitterLayout();
        if (layout == null) {
            return;
        }
        if (dragStartPos == null) {
            return;
        }
        if (!this.liveLayout) {
            int x = e.getX() + this.getX();
            int y = e.getY() + this.getY();
            DragGlassPane.getInstance().deactivate();
            Point delta = new Point(x - SplitterBar.dragStartPos.x, y - SplitterBar.dragStartPos.y);
            if (this.orientation == 0) {
                delta.x = 0;
            } else {
                delta.y = 0;
            }
            layout.processSplitterDrag(this, delta, true);
        }
        dragStartPos = null;
        this.updateStatus();
    }

    void mouseEnter(MouseEvent e) {
        this.mouseInside = true;
        this.updateStatus();
    }

    void mouseExit(MouseEvent e) {
        this.mouseInside = false;
        this.updateStatus();
    }

    protected void updateStatus() {
        this.repaint();
        Cursor cursor = DEF_CURSOR;
        if (this.mouseInside || dragStartPos != null) {
            cursor = this.orientation == 0 ? VERT_CURSOR : HORIZ_CURSOR;
        }
        this.setCursor(cursor);
    }

    private SplitterLayout getSplitterLayout() {
        LayoutManager layout = this.getParent().getLayout();
        if (layout instanceof SplitterLayout) {
            return (SplitterLayout)layout;
        }
        return null;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.mouseInside && dragStartPos == null) {
            g.setColor(FOCUSCOLOR);
        } else {
            g.setColor(ENABLED_BORDERCOLOR);
        }
        Component[] c = this.getComponents();
        if (c != null && c.length > 0) {
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof SplitterSpace)) continue;
                Rectangle r = c[i].getBounds();
                this.draw3DRect(g, r);
            }
        } else {
            Rectangle r = this.getBounds();
            r.y = 0;
            r.x = 0;
            this.draw3DRect(g, r);
        }
    }

    private void draw3DRect(Graphics g, Rectangle r) {
        if (this.orientation == 0) {
            g.fill3DRect(2, r.height / 2 - 1, r.width - 5, 3, true);
        } else {
            g.fill3DRect(r.width / 2 - 1, 2, 3, r.height - 5, true);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[");
        sb.append("orientation=");
        sb.append(this.orientation == 0 ? "vertical" : "horizontal");
        sb.append("liveLayout=");
        sb.append(this.liveLayout ? "true" : "false");
        sb.append("]");
        return sb.toString();
    }

    static {
        FOCUSCOLOR = new Color(255, 212, 142, 254);
        ENABLED_BORDERCOLOR = new Color(149, 176, 203, 254);
    }
}

