/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class SkyButtonUI
extends MetalButtonUI {
    private Rectangle iconrect = new Rectangle();
    private Rectangle textrect = new Rectangle();
    private Rectangle viewrect = new Rectangle();
    private String text;
    private int shadowDepth = 4;
    private boolean isShadowOn = true;

    public static ComponentUI createUI(JComponent c) {
        return new SkyButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        super.installUI(b);
        LookAndFeel.installColorsAndFont(b, "Button.enabled_background", "Button.enabled_foreground", "Button.enabled_font");
        LookAndFeel.installBorder(b, "Button.border");
    }

    public boolean isShadowOn() {
        return this.isShadowOn;
    }

    public void setShadowOn(boolean shadowOn) {
        this.isShadowOn = shadowOn;
    }

    public void setShadowDepth(int depth) {
        this.shadowDepth = depth;
    }

    public int getShadowDepth() {
        return this.shadowDepth;
    }

    private int calculateShadowDepth(AbstractButton b) {
        if (this.isShadowOn()) {
            int depth = 4;
            if (b.getModel().isPressed()) {
                depth -= 2;
            } else if (b.getModel().isRollover()) {
                depth += 2;
            }
            return depth;
        }
        return 0;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        g.setFont(b.getFont());
        this.setShadowDepth(this.calculateShadowDepth(b));
        if (this.isShadowOn()) {
            this.viewrect.x = 4 - this.getShadowDepth();
            this.viewrect.y = 4 - this.getShadowDepth();
            this.viewrect.width = b.getWidth() - 4;
            this.viewrect.height = b.getHeight() - 4;
        } else {
            this.viewrect.x = 0;
            this.viewrect.y = 0;
            this.viewrect.width = b.getWidth();
            this.viewrect.height = b.getHeight();
        }
        g2d.setColor(b.getParent().getBackground());
        g2d.fillRect(0, 0, b.getWidth(), b.getHeight());
        g2d.setColor(b.getBackground());
        if (b.isSelected()) {
            g2d.setColor(UIManager.getColor("Button.selectedBackground"));
        } else if (b.getModel().isPressed()) {
            g2d.setColor(UIManager.getColor("Button.pressedBackground"));
        }
        g2d.fillRect(this.viewrect.x, this.viewrect.y, this.viewrect.width, this.viewrect.height);
        this.iconrect.height = 0;
        this.iconrect.width = 0;
        this.iconrect.y = 0;
        this.iconrect.x = 0;
        this.textrect.height = 0;
        this.textrect.width = 0;
        this.textrect.y = 0;
        this.textrect.x = 0;
        this.text = SwingUtilities.layoutCompoundLabel(b, g.getFontMetrics(), b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewrect, this.iconrect, this.textrect, b.getText() == null ? 0 : b.getIconTextGap());
        try {
            this.paintIcon(g, b, this.iconrect);
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        this.paintText(g, c, this.textrect, this.text);
        if (b.isFocusOwner()) {
            int fx1 = this.textrect.x;
            int fy = this.textrect.y + this.textrect.height - 1;
            int fx2 = fx1 + this.textrect.width;
            g2d.setColor(UIManager.getColor("Button.focusColor"));
            g2d.drawLine(fx1, fy, fx2, fy);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (d == null) {
            return null;
        }
        d.width += 4;
        d.height += 4;
        return d;
    }
}

