/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.openbp.swing.AdvancedAccelerator;

public class SkyMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    private static final boolean DEBUG = false;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new SkyMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(prefix + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(prefix + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(prefix + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(prefix + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(prefix + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(prefix + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(prefix + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(prefix + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(prefix + ".checkIcon");
        }
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent p = (JComponent)parent;
            p.putClientProperty(MAX_ACC_WIDTH, null);
            p.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = propertyPrefix + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(uiKey);
        if (am == null) {
            am = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am);
        }
        return am;
    }

    ActionMap createActionMap() {
        return new ActionMapUIResource();
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        String acceleratorText = this.getAcceleratorString();
        Font font = b.getFont();
        Toolkit kit = Toolkit.getDefaultToolkit();
        FontMetrics fm = kit.getFontMetrics(font);
        FontMetrics fmAccel = kit.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(SkyMenuItemUI.iconRect.x, SkyMenuItemUI.iconRect.y, SkyMenuItemUI.iconRect.width, SkyMenuItemUI.iconRect.height, r);
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxAccValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int n = maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            if (SkyMenuItemUI.r.width < maxTextValue) {
                SkyMenuItemUI.r.width = maxTextValue;
            } else {
                p.putClientProperty(MAX_TEXT_WIDTH, new Integer(SkyMenuItemUI.r.width));
            }
            if (SkyMenuItemUI.acceleratorRect.width > maxAccValue) {
                maxAccValue = SkyMenuItemUI.acceleratorRect.width;
                p.putClientProperty(MAX_ACC_WIDTH, new Integer(SkyMenuItemUI.acceleratorRect.width));
            }
            SkyMenuItemUI.r.width += maxAccValue;
            SkyMenuItemUI.r.width += defaultTextIconGap;
        }
        if (this.useCheckAndArrow()) {
            SkyMenuItemUI.r.width += SkyMenuItemUI.checkIconRect.width;
            SkyMenuItemUI.r.width += defaultTextIconGap;
            SkyMenuItemUI.r.width += defaultTextIconGap;
            SkyMenuItemUI.r.width += SkyMenuItemUI.arrowIconRect.width;
        }
        SkyMenuItemUI.r.width += 2 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            SkyMenuItemUI.r.width += insets.left + insets.right;
            SkyMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (SkyMenuItemUI.r.width % 2 == 0) {
            ++SkyMenuItemUI.r.width;
        }
        if (SkyMenuItemUI.r.height % 2 == 0) {
            ++SkyMenuItemUI.r.height;
        }
        return r.getSize();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        SkyMenuItemUI.viewRect.x += i.left;
        SkyMenuItemUI.viewRect.y += i.top;
        SkyMenuItemUI.viewRect.width -= i.right + SkyMenuItemUI.viewRect.x;
        SkyMenuItemUI.viewRect.height -= i.bottom + SkyMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        String acceleratorText = this.getAcceleratorString();
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (this.useCheckAndArrow() && b.isSelected()) {
                checkIcon.paintIcon(c, g, SkyMenuItemUI.checkIconRect.x, SkyMenuItemUI.checkIconRect.y);
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c, g, SkyMenuItemUI.iconRect.x, SkyMenuItemUI.iconRect.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : SkyMenuItemUI.acceleratorRect.width;
                accOffset = maxValue - SkyMenuItemUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, SkyMenuItemUI.acceleratorRect.x - accOffset, SkyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, SkyMenuItemUI.acceleratorRect.x - accOffset, SkyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(b.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, SkyMenuItemUI.acceleratorRect.x - accOffset - 1, SkyMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, SkyMenuItemUI.acceleratorRect.x - accOffset, SkyMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, SkyMenuItemUI.arrowIconRect.x, SkyMenuItemUI.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(menuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(menuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j;
            for (j = oldPath.length - 1; j >= 0 && oldPath[j].getComponent() != parent; --j) {
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    void printMenuElementArray(MenuElement[] path, boolean dumpStack) {
        System.out.println("Path is(");
        int j = path.length;
        for (int i = 0; i < j; ++i) {
            for (int k = 0; k <= i; ++k) {
                System.out.print("  ");
            }
            MenuElement me = path[i];
            if (me instanceof JMenuItem) {
                System.out.println(((JMenuItem)me).getText() + ", ");
                continue;
            }
            if (me == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + me + ", ");
        }
        System.out.println(")");
        if (dumpStack) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager msm) {
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    public String getAcceleratorString() {
        if (this.menuItem instanceof AdvancedAccelerator) {
            return ((AdvancedAccelerator)((Object)this.menuItem)).getAcceleratorString();
        }
        KeyStroke accelerator = this.menuItem.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        return acceleratorText;
    }

    public static class CheckIcon
    implements Icon {
        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setStroke(new BasicStroke(1.5f));
            }
            g.setColor(Color.DARK_GRAY);
            g.drawLine(x, y + 5, x + 3, y + 8);
            g.drawLine(x + 3, y + 8, x + 8, y);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                SkyMenuItemUI.this.updateAcceleratorBinding();
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
            int key = SkyMenuItemUI.this.menuItem.getMnemonic();
            if (key == 0) {
                return;
            }
            if (this.lower(key) == this.lower(e.getKeyChar())) {
                MenuSelectionManager manager = e.getMenuSelectionManager();
                SkyMenuItemUI.this.doClick(manager);
                e.consume();
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private int lower(int ascii) {
            if (ascii >= 65 && ascii <= 90) {
                return ascii + 97 - 65;
            }
            return ascii;
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < SkyMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < SkyMenuItemUI.this.menuItem.getHeight()) {
                SkyMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < SkyMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < SkyMenuItemUI.this.menuItem.getHeight()) {
                SkyMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(SkyMenuItemUI.this.getPath());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int c = path.length - 1;
                    for (int i = 0; i < c; ++i) {
                        newPath[i] = path[i];
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

