/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.plaf.sky;

import java.awt.AWTException;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.openbp.swing.plaf.sky.SkyUtil;

public class SkyPopupMenuUI
extends BasicPopupMenuUI {
    private static Image oldbg;
    private static Rectangle oldrect;
    private Image background;
    private MediaTracker tracker;

    public static ComponentUI createUI(JComponent c) {
        return new SkyPopupMenuUI();
    }

    protected void updateBackground() {
        try {
            Robot rob = new Robot();
            Rectangle r = this.popupMenu.getBounds();
            Point p = this.popupMenu.getLocationOnScreen();
            r.x = p.x;
            r.y = p.y;
            r.width += 8;
            r.height += 8;
            if (r.width != 0 && r.height != 0 && rob != null) {
                this.background = rob.createScreenCapture(r);
            }
            this.tracker = new MediaTracker(this.popupMenu);
            this.tracker.addImage(this.background, 1);
            this.tracker.waitForAll();
            if (oldrect != null) {
                Graphics g = this.background.getGraphics();
                g.drawImage(oldbg, SkyPopupMenuUI.oldrect.x - r.x, SkyPopupMenuUI.oldrect.y - r.y, null);
            }
            oldrect = r;
            oldbg = this.background;
        }
        catch (InterruptedException ie) {
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        this.updateBackground();
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, null);
        }
        g.setColor(comp.getBackground());
        Insets ins = comp.getInsets();
        g.fillRect(ins.left, ins.top, comp.getWidth() - ins.left - ins.right, comp.getHeight() - ins.top - ins.bottom);
        super.paint(g, comp);
        SkyUtil.paintRectShadow(g, 0, 0, comp.getWidth(), comp.getHeight());
    }
}

