/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import org.openbp.swing.SwingUtil;

public final class DragGlassPane
extends JComponent {
    private static DragGlassPane singletonInstance = null;
    private int borderWidth = 3;
    private Rectangle targetRect;
    private boolean fill = false;
    private RootPaneContainer container;
    private Component originalGlassPane;

    public static synchronized DragGlassPane getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DragGlassPane();
        }
        return singletonInstance;
    }

    private DragGlassPane() {
    }

    public void activate(Component c) {
        this.deactivate();
        while (c != null) {
            if (c instanceof RootPaneContainer) {
                this.container = (RootPaneContainer)((Object)c);
                break;
            }
            c = c.getParent();
        }
        if (this.container == null) {
            throw new IllegalArgumentException("The active component is not contained in a root pane container.");
        }
        this.originalGlassPane = this.container.getGlassPane();
        this.container.setGlassPane(this);
        this.setSize(this.container.getContentPane().getSize());
    }

    public void deactivate() {
        if (this.container != null) {
            this.container.setGlassPane(this.originalGlassPane);
            this.container = null;
            this.originalGlassPane = null;
            this.targetRect = null;
        }
    }

    public void drawRectangle(Rectangle newTargetRect, boolean fill) {
        Rectangle paintArea = null;
        paintArea = this.targetRect != null ? (newTargetRect != null ? this.targetRect.union(newTargetRect) : this.targetRect) : newTargetRect;
        this.targetRect = newTargetRect;
        this.fill = fill;
        if (paintArea != null) {
            SwingUtil.inflateRectangle(paintArea, 1, 1);
            this.repaint(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
        }
        this.setVisible(true);
    }

    public void clearRectangle() {
        if (this.targetRect != null) {
            Rectangle paintArea = new Rectangle(this.targetRect);
            this.targetRect = null;
            SwingUtil.inflateRectangle(paintArea, 1, 1);
            this.repaint(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
        }
        this.setVisible(false);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.targetRect = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.targetRect != null) {
            g.setColor(Color.black);
            g.setXORMode(Color.gray);
            if (this.fill) {
                g.fillRect(this.targetRect.x, this.targetRect.y, this.targetRect.width, this.targetRect.height);
            } else {
                Rectangle r = new Rectangle(this.targetRect);
                for (int i = this.borderWidth; i > 0; --i) {
                    g.drawRect(r.x, r.y, r.width, r.height);
                    if (r.width <= 2 || r.height <= 2) break;
                    SwingUtil.inflateRectangle(r, -1, -1);
                }
            }
        }
    }
}

