/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openbp.common.ExceptionUtil;
import org.openbp.swing.SwingUtil;

public class JMultiSplitPane
extends JPanel
implements ComponentListener {
    public static final int HORIZONTAL_SPLIT = 1;
    public static final int VERTICAL_SPLIT = 0;
    private int orientation = 1;
    private List panes = new ArrayList();
    private double[] proportions;
    private boolean changing;

    public JMultiSplitPane() {
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.setFocusable(false);
    }

    public JMultiSplitPane(int orientation) {
        this();
        this.orientation = orientation;
    }

    public void addClient(Component comp, int index) {
        if (comp instanceof JMultiSplitPane && ((JMultiSplitPane)comp).getOrientation() == this.orientation) {
            this.insertAllClients(((JMultiSplitPane)comp).getClients(), index);
            return;
        }
        int elements = this.getClientCount();
        if (index == elements) {
            index = -1;
        } else if (index > elements) {
            throw new IllegalArgumentException();
        }
        if (elements == 0) {
            this.add(comp);
        } else if (index == 0) {
            JSplitPane newPane = this.createSplitPane(this.orientation, comp, this.getComponent(0));
            this.removeAll();
            this.add(newPane);
            this.panes.add(0, newPane);
        } else if (index == -1) {
            if (elements == 1) {
                JSplitPane newPane = this.createSplitPane(this.orientation, this.getComponent(0), comp);
                this.removeAll();
                this.add(newPane);
                this.panes.add(newPane);
            } else {
                JSplitPane last = (JSplitPane)this.panes.get(this.panes.size() - 1);
                JSplitPane newPane = this.createSplitPane(this.orientation, last.getRightComponent(), comp);
                last.setRightComponent(newPane);
                this.panes.add(newPane);
            }
        } else {
            JSplitPane last = (JSplitPane)this.panes.get(index - 1);
            JSplitPane newPane = this.createSplitPane(this.orientation, comp, last.getRightComponent());
            last.setRightComponent(newPane);
            this.panes.add(index, newPane);
        }
        this.proportions = null;
        this.layoutDividers();
        this.revalidate();
    }

    public void removeClient(int index) {
        if (index < 0) {
            return;
        }
        int elements = this.getClientCount();
        if (index >= elements) {
            throw new IllegalArgumentException();
        }
        if (elements == 1) {
            this.removeAll();
            Container parent = this.getParent();
            while (parent instanceof JSplitPane) {
                parent = parent.getParent();
            }
            if (parent instanceof JMultiSplitPane) {
                ((JMultiSplitPane)parent).removeClient(this);
            }
        } else if (elements == 2) {
            Component c = index == 1 ? ((JSplitPane)this.panes.get(0)).getLeftComponent() : ((JSplitPane)this.panes.get(0)).getRightComponent();
            this.removeAll();
            this.add(c);
            this.panes.clear();
        } else if (index == elements - 1) {
            ((JSplitPane)this.panes.get(index - 2)).setRightComponent(((JSplitPane)this.panes.get(index - 1)).getLeftComponent());
            this.panes.remove(index - 1);
        } else if (index == 0) {
            this.removeAll();
            this.add(((JSplitPane)this.panes.get(0)).getRightComponent());
            this.panes.remove(0);
        } else {
            ((JSplitPane)this.panes.get(index - 1)).setRightComponent(((JSplitPane)this.panes.get(index)).getRightComponent());
            this.panes.remove(index);
        }
        this.proportions = null;
        this.layoutDividers();
        this.revalidate();
    }

    public void addClient(Component comp) {
        this.addClient(comp, -1);
    }

    public void insertAllClients(Component[] comps, int index) {
        for (int i = comps.length; i > 0; --i) {
            this.addClient(comps[i - 1], index);
        }
    }

    public void addClientBefore(Component current, Component add) {
        this.addClient(add, this.getIndexOfClient(current));
    }

    public void addClientAfter(Component current, Component add) {
        this.addClient(add, this.getIndexOfClient(current) + 1);
    }

    public void removeClient(Component comp) {
        this.removeClient(this.getIndexOfClient(comp));
    }

    public void replaceClient(int index, Component substitute) {
        double[] oldProportions = new double[this.proportions.length];
        System.arraycopy(this.proportions, 0, oldProportions, 0, this.proportions.length);
        this.removeClient(index);
        this.addClient(substitute, index);
        System.arraycopy(oldProportions, 0, this.proportions, 0, this.proportions.length);
        this.layoutDividers();
    }

    public void replaceClient(Component old, Component substitute) {
        this.replaceClient(this.getIndexOfClient(old), substitute);
    }

    public Component getClient(int n) {
        int elements = this.getClientCount();
        if (elements == 1) {
            return this.getComponent(0);
        }
        return n < elements - 1 ? ((JSplitPane)this.panes.get(n)).getLeftComponent() : ((JSplitPane)this.panes.get(n - 1)).getRightComponent();
    }

    public int getClientCount() {
        int result = this.panes.size() + 1;
        if (result == 1) {
            return this.getComponentCount();
        }
        return result;
    }

    public Component[] getClients() {
        int elements = this.getClientCount();
        Component[] result = new Component[elements];
        for (int i = 0; i < elements; ++i) {
            result[i] = this.getClient(i);
        }
        return result;
    }

    public int getIndexOfClient(Component comp) {
        Component[] comps = this.getClients();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != comp) continue;
            return i;
        }
        return -1;
    }

    public void setClientProportions(double[] proportions) {
        this.proportions = proportions;
        this.layoutDividers();
    }

    public double[] getClientProportions() {
        return this.proportions;
    }

    public void createDefaultProportions() {
        int elements = this.getClientCount();
        this.proportions = new double[elements];
        if (elements > 0) {
            double delta = 1.0 / (double)elements;
            for (int i = 0; i < elements; ++i) {
                this.proportions[i] = delta;
            }
            this.proportions[elements - 1] = 1.0 - (double)(elements - 1) * delta;
        }
    }

    protected void layoutDividers() {
        int total;
        if (this.changing) {
            return;
        }
        int n = total = this.orientation == 1 ? this.getSize().width : this.getSize().height;
        if (total == 0) {
            return;
        }
        this.changing = true;
        int nClients = this.getClientCount();
        if (this.proportions == null || this.proportions.length != nClients) {
            this.createDefaultProportions();
        }
        int nPanes = this.panes.size();
        for (int i = 0; i < nPanes; ++i) {
            int pos = (int)((double)total * this.proportions[i] - (double)(2 * i));
            ((JSplitPane)this.panes.get(i)).setDividerLocation(pos);
        }
        this.changing = false;
    }

    public int getOrientation() {
        return this.orientation;
    }

    private JSplitPane createSplitPane(int orientation, Component c1, Component c2) {
        JSplitPane pane = new JSplitPane(orientation, c1, c2);
        pane.setBorder(null);
        pane.setTransferHandler(this.getTransferHandler());
        return pane;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.layoutDividers();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.layoutDividers();
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer("JMultiSplitPane ");
        output.append(this.orientation == 0 ? "(vert)" : "(hor)");
        output.append(" [");
        Component[] compos = this.getClients();
        for (int i = 0; i < compos.length; ++i) {
            output.append(compos[i].toString());
            output.append(", ");
        }
        output.append("]");
        return output.toString();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        try {
            UIManager.setLookAndFeel("org.openbp.swing.plaf.sky.SkyLookAndFeel");
            if (frame != null) {
                SwingUtilities.updateComponentTreeUI(frame);
            }
        }
        catch (Exception e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        JMultiSplitPane multi = new JMultiSplitPane();
        JMultiSplitPane sulti = new JMultiSplitPane(0);
        for (int i = 0; i < 5; ++i) {
            multi.addClient(new JScrollPane(new JLabel("Label " + i)));
            sulti.addClient(new JScrollPane(new JLabel("SLabel " + i)));
        }
        multi.addClient(new JScrollPane(new JLabel("Mitte")), 3);
        multi.addClient(sulti, 3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(multi);
        frame.pack();
        SwingUtil.show(frame);
    }
}

