/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JStandardDialog;

public class PasswordDialog
extends JStandardDialog {
    private ResourceCollection res;
    private JPasswordField pwd1;
    private JPasswordField pwd2;
    private String password;
    private boolean definePassword;

    public PasswordDialog(Frame owner, boolean definePassword, ResourceCollection res) {
        super(owner, true);
        this.definePassword = definePassword;
        this.res = res;
        this.initialize();
        this.pack();
    }

    public PasswordDialog(Dialog owner, boolean definePassword, ResourceCollection res) {
        super(owner, true);
        this.definePassword = definePassword;
        this.res = res;
        this.initialize();
    }

    private void initialize() {
        this.setTitle(this.res.getRequiredString("password-dialog.title"));
        this.setCancelled(true);
        Box pane = Box.createVerticalBox();
        pane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getMainPane().setLayout(new BorderLayout());
        this.getMainPane().add((Component)pane, "Center");
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(this.getMainPane().getBackground());
        JLabel label = new JLabel(this.res.getRequiredString("password-dialog.message"));
        label.setHorizontalAlignment(2);
        label.setVerticalAlignment(1);
        labelPanel.add((Component)label, "Center");
        pane.add(labelPanel);
        pane.add(Box.createVerticalStrut(6));
        Box b1 = Box.createHorizontalBox();
        pane.add(b1);
        pane.add(Box.createVerticalStrut(3));
        b1.add(new JLabel(this.res.getRequiredString("password-dialog.password1")));
        b1.add(Box.createHorizontalStrut(10));
        this.pwd1 = new JPasswordField(10);
        b1.add(this.pwd1);
        if (this.definePassword) {
            Box b2 = Box.createHorizontalBox();
            pane.add(b2);
            pane.add(Box.createVerticalStrut(3));
            b2.add(new JLabel(this.res.getRequiredString("password-dialog.password2")));
            b2.add(Box.createHorizontalStrut(10));
            this.pwd2 = new JPasswordField(10);
            b2.add(this.pwd2);
        }
        this.pack();
        if (this.getOwner() != null) {
            this.setLocationRelativeTo(this.getOwner());
        }
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    protected void handleOk() {
        char[] tmp1 = this.pwd1.getPassword();
        boolean tmp2IsNull = this.definePassword;
        if (this.definePassword) {
            char[] tmp2 = this.pwd2.getPassword();
            boolean equals = Arrays.equals(tmp1, tmp2);
            if (!equals) {
                JOptionPane.showMessageDialog(this, this.res.getRequiredString("password-dialog.errormessage.notequal"));
                return;
            }
            boolean bl = tmp2IsNull = tmp2 == null || tmp2.length == 0;
        }
        if (tmp1 == null || tmp1.length == 0 || tmp2IsNull) {
            JOptionPane.showMessageDialog(this, this.res.getRequiredString("password-dialog.errormessage.isnull"));
            return;
        }
        this.password = tmp1.toString();
        this.setCancelled(false);
        super.handleOk();
    }

    public static void main(String[] args) {
        PasswordDialog dialog = new PasswordDialog((Frame)null, true, null);
        dialog.pack();
        SwingUtil.show(dialog);
        if (dialog.isCancelled()) {
            System.out.println("cancelled");
        } else {
            System.out.println(dialog.getPassword());
        }
    }
}

